<?php
/**
 * Configuração de conexão com o banco de dados
 * Sistema de Gerenciamento Eletrônico de Documentos (GED)
 */

class Database {
    private $host = "localhost";
    private $db_name = "ged_db1";
    private $username = "root";
    private $password = "password";
    private $conn;

    /**
     * Obtém a conexão com o banco de dados
     * @return PDO Objeto de conexão PDO
     */
    public function getConnection() {
        $this->conn = null;

        try {
            $this->conn = new PDO(
                "mysql:host=" . $this->host . ";dbname=" . $this->db_name,
                $this->username,
                $this->password
            );
            $this->conn->exec("set names utf8");
            $this->conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        } catch(PDOException $exception) {
            echo "Erro de conexão: " . $exception->getMessage();
        }

        return $this->conn;
    }
}
?>
