#!/bin/bash

# Script de instalação para o Sistema de Gerenciamento Eletrônico de Documentos (GED)
# Para uso em ambiente cPanel

echo "Iniciando instalação do Sistema GED..."

# Verificar se o Python está disponível
if command -v python3 &>/dev/null; then
    PYTHON_CMD="python3"
elif command -v python &>/dev/null; then
    PYTHON_CMD="python"
else
    echo "ERRO: Python não encontrado. Por favor, instale o Python 3.8 ou superior."
    exit 1
fi

echo "Usando Python: $($PYTHON_CMD --version)"

# Criar ambiente virtual
echo "Criando ambiente virtual..."
$PYTHON_CMD -m venv venv
source venv/bin/activate

# Instalar dependências
echo "Instalando dependências..."
pip install -r requirements.txt

# Verificar se o MySQL está disponível
if command -v mysql &>/dev/null; then
    echo "MySQL encontrado."
else
    echo "AVISO: MySQL não encontrado no PATH. Certifique-se de que o MySQL está disponível no seu ambiente cPanel."
fi

# Criar diretório de uploads se não existir
echo "Configurando diretório de uploads..."
mkdir -p src/static/uploads
chmod 755 src/static/uploads

echo "Instalação básica concluída!"
echo ""
echo "Para completar a configuração:"
echo "1. Importe o arquivo database/setup.sql no seu banco de dados MySQL"
echo "2. Configure o arquivo .env com suas credenciais"
echo "3. Configure o arquivo .htaccess para redirecionar para o script WSGI"
echo ""
echo "Consulte o arquivo INSTALL.md para instruções detalhadas."
