-- Correções para o Banco de Dados do Sistema GED
-- Execute estes comandos no MySQL para corrigir os problemas identificados

-- 1. Corrigir a senha do usuário admin
UPDATE user SET password_hash = '$2y$10$EIQo2geseDoOvXoApkCW2uZ2zGB6LjIhr/PTiGmjJVzIHJQ4/FeFy' 
WHERE username = 'admin';

-- 2. Verificar se as colunas necessárias existem na tabela workflow_step
-- Se não existirem, adicione-as:

-- Verificar estrutura atual da tabela workflow_step
DESCRIBE workflow_step;

-- Adicionar colunas se não existirem (execute apenas se necessário)
-- ALTER TABLE workflow_step ADD COLUMN assigned_to_user_type ENUM('admin', 'user', 'any') DEFAULT 'any';
-- ALTER TABLE workflow_step ADD COLUMN assigned_to_user_id INT NULL;

-- 3. Verificar se todas as permissões necessárias existem
SELECT * FROM permission WHERE name IN (
    'view_document', 'upload_document', 'edit_document', 'delete_document',
    'manage_users', 'manage_permissions', 'manage_categories', 'manage_workflows',
    'view_audit_logs'
);

-- 4. Inserir permissões faltantes se necessário
INSERT IGNORE INTO permission (name, description) VALUES
('view_document', 'Visualizar documentos'),
('upload_document', 'Fazer upload de documentos'),
('edit_document', 'Editar documentos'),
('delete_document', 'Excluir documentos'),
('manage_users', 'Gerenciar usuários'),
('manage_permissions', 'Gerenciar permissões'),
('manage_categories', 'Gerenciar categorias'),
('manage_workflows', 'Gerenciar workflows'),
('view_audit_logs', 'Visualizar logs de auditoria');

-- 5. Garantir que o usuário admin tenha todas as permissões
INSERT IGNORE INTO user_permission (user_id, permission_id)
SELECT 1, id FROM permission;

-- 6. Verificar integridade dos dados
SELECT 
    u.username,
    COUNT(up.permission_id) as total_permissions
FROM user u
LEFT JOIN user_permission up ON u.id = up.user_id
WHERE u.username = 'admin'
GROUP BY u.id, u.username;

-- 7. Verificar logs de auditoria
SELECT COUNT(*) as total_audit_logs FROM audit_log;

-- 8. Verificar categorias
SELECT COUNT(*) as total_categories FROM category;

-- 9. Verificar workflows
SELECT COUNT(*) as total_workflows FROM workflow;

-- 10. Verificar estrutura das tabelas principais
SHOW TABLES LIKE '%workflow%';
SHOW TABLES LIKE '%document%';
SHOW TABLES LIKE '%user%';
SHOW TABLES LIKE '%permission%';
SHOW TABLES LIKE '%category%';
SHOW TABLES LIKE '%audit%';

