<?php
/**
 * Página de exclusão de documento
 * Sistema de Gerenciamento Eletrônico de Documentos (GED)
 */

// Iniciar sessão e verificar autenticação
session_start();
if (!isset($_SESSION["user_id"])) {
    header("Location: login.php");
    exit;
}

// Verificar se o ID do documento foi fornecido
if (!isset($_GET["id"]) || empty($_GET["id"])) {
    $_SESSION["flash_message"] = "ID do documento não fornecido.";
    $_SESSION["flash_type"] = "danger";
    header("Location: documents.php");
    exit;
}

$document_id = $_GET["id"];

// Incluir arquivos necessários
require_once "config/database.php";
require_once "models/document.php";
require_once "models/audit_log.php";
require_once "controllers/document_controller.php";

// Conectar ao banco de dados
$database = new Database();
$db = $database->getConnection();

// Instanciar controlador
$document_controller = new DocumentController();

// Obter detalhes do documento para verificar permissão e registrar log
$document = new Document($db);
if (!$document->readOne($document_id)) {
    $_SESSION["flash_message"] = "Documento não encontrado.";
    $_SESSION["flash_type"] = "danger";
    header("Location: documents.php");
    exit;
}

// Verificar permissão para excluir o documento
$user_id = $_SESSION["user_id"];
$user_type = $_SESSION["user_type"];

if ($document->created_by != $user_id && $user_type != "admin") {
    $_SESSION["flash_message"] = "Você não tem permissão para excluir este documento.";
    $_SESSION["flash_type"] = "danger";
    header("Location: documents.php");
    exit;
}

// Tentar excluir o documento
$result = $document_controller->deleteDocument($document_id, $user_id);

if ($result["success"]) {
    $_SESSION["flash_message"] = "Documento excluído com sucesso!";
    $_SESSION["flash_type"] = "success";
} else {
    $_SESSION["flash_message"] = $result["message"];
    $_SESSION["flash_type"] = "danger";
}

header("Location: documents.php");
exit;

?>

