<?php
/**
 * Script para download de arquivos de backup
 * Sistema de Gerenciamento Eletrônico de Documentos (GED)
 */

// Iniciar sessão e verificar autenticação
session_start();
if (!isset($_SESSION["user_id"])) {
    header("Location: login.php");
    exit;
}

// Verificar se o usuário tem permissão de administrador
if ($_SESSION["user_type"] != "admin") {
    $_SESSION["flash_message"] = "Acesso negado. Você não tem permissão para acessar esta funcionalidade.";
    $_SESSION["flash_type"] = "danger";
    header("Location: index.php");
    exit;
}

// Incluir arquivos necessários
require_once "config/config.php";
require_once "models/audit_log.php";

$backup_dir = BASE_PATH . "/backups";

if (isset($_GET["file"])) {
    $filename = basename($_GET["file"]); // Usar basename para evitar Path Traversal
    $filepath = $backup_dir . "/" . $filename;

    if (file_exists($filepath) && preg_match("/^ged_backup_.*\.zip$/", $filename)) {
        header("Content-Description: File Transfer");
        header("Content-Type: application/octet-stream");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        header("Expires: 0");
        header("Cache-Control: must-revalidate");
        header("Pragma: public");
        header("Content-Length: " . filesize($filepath));
        flush(); // Limpar o buffer de saída
        readfile($filepath);

        // Registrar log de auditoria
        $database = new Database();
        $db = $database->getConnection();
        $audit_log = new AuditLog($db);
        $audit_log->user_id = $_SESSION["user_id"];
        $audit_log->action = "download_backup";
        $audit_log->entity_type = "system";
        $audit_log->entity_id = null;
        $audit_log->details = "Backup baixado: " . $filename;
        $audit_log->ip_address = $_SERVER["REMOTE_ADDR"] ?? "0.0.0.0";
        $audit_log->user_agent = $_SERVER["HTTP_USER_AGENT"] ?? "Unknown";
        $audit_log->create();

        exit;
    } else {
        $_SESSION["flash_message"] = "Arquivo de backup não encontrado ou inválido.";
        $_SESSION["flash_type"] = "danger";
        header("Location: backup.php");
        exit;
    }
} else {
    $_SESSION["flash_message"] = "Nome do arquivo de backup não especificado.";
    $_SESSION["flash_type"] = "danger";
    header("Location: backup.php");
    exit;
}
?>

