# Instruções para o Sistema GED

## Como Proceder Após as Correções

### 1. Aplicar Correções no Banco de Dados

Execute o arquivo `correcoes_banco_dados.sql` no seu banco de dados MySQL:

```bash
mysql -u seu_usuario -p ged_db1 < correcoes_banco_dados.sql
```

### 2. Testar o Login

Após aplicar as correções SQL, teste o login com:
- **Usuário**: admin
- **Senha**: admin123

### 3. Verificar Funcionalidades

Acesse o sistema através do arquivo `index.php` e teste:

1. **Login** - Deve funcionar com admin/admin123
2. **Gerenciamento de Usuários** - Criar, editar, excluir usuários
3. **Gerenciamento de Categorias** - Todas as operações CRUD
4. **Upload de Documentos** - Testar com arquivos PDF, DOC, JPG
5. **Sistema de Pesquisa** - Buscar documentos por título, autor, etc.
6. **Logs de Auditoria** - Verificar se as ações estão sendo registradas

### 4. Problemas Conhecidos e Soluções

#### 4.1 Upload de Documentos Falha
**Problema**: "Tipo de arquivo não permitido"
**Solução**: Verificar as extensões permitidas no `DocumentController` e ajustar conforme necessário.

#### 4.2 Workflow Não Funciona
**Problema**: Colunas não existem no banco de dados
**Solução**: Executar os comandos ALTER TABLE no arquivo de correções SQL.

#### 4.3 Backup Não Testado
**Problema**: BackupController não incluído nos testes
**Solução**: Verificar se o arquivo existe e incluir no sistema de testes.

### 5. Estrutura de Arquivos

```
ged_php/
├── config/
│   ├── config.php
│   └── database.php
├── models/
│   ├── user.php
│   ├── document.php
│   ├── category.php
│   ├── workflow.php
│   ├── audit_log.php
│   └── ...
├── controllers/
│   ├── auth_controller.php
│   ├── document_controller.php
│   ├── category_controller.php
│   └── ...
├── includes/
│   ├── header.php
│   ├── footer.php
│   └── sidebar.php
├── index.php
├── login.php
├── documents.php
├── categories.php
└── ...
```

### 6. Configuração do Banco de Dados

Certifique-se de que o arquivo `config/database.php` está configurado corretamente:

```php
<?php
class Database {
    private $host = "localhost";
    private $db_name = "ged_db1";
    private $username = "seu_usuario";
    private $password = "sua_senha";
    // ...
}
?>
```

### 7. Permissões de Arquivo

Certifique-se de que o diretório de upload tem as permissões corretas:

```bash
chmod 755 uploads/
chmod 644 uploads/*
```

### 8. Logs de Erro

Para debug, verifique os logs de erro do PHP:
- Logs do Apache: `/var/log/apache2/error.log`
- Logs do PHP: `/var/log/php/error.log`

### 9. Melhorias Recomendadas

1. **Segurança**:
   - Implementar CSRF protection
   - Validar uploads de arquivo mais rigorosamente
   - Usar HTTPS em produção

2. **Performance**:
   - Implementar cache para consultas frequentes
   - Otimizar consultas SQL
   - Implementar paginação em listagens grandes

3. **Usabilidade**:
   - Melhorar interface do usuário
   - Adicionar notificações de sucesso/erro
   - Implementar busca avançada

### 10. Suporte

Se encontrar problemas:

1. Verifique os logs de erro
2. Execute o teste de integração: `php test_integration.php`
3. Consulte o relatório final em `relatorio_sistema_ged.md`
4. Verifique se todas as correções SQL foram aplicadas

### 11. Backup e Manutenção

- Configure backups automáticos do banco de dados
- Monitore o espaço em disco para uploads
- Mantenha logs de auditoria organizados
- Atualize senhas regularmente

---

**Importante**: Este sistema foi testado e corrigido, mas recomenda-se testes adicionais em ambiente de produção antes do uso final.

