# Manual de Instalação - Sistema GED para cPanel
## Guia Completo para Hospedagem Manual

**Versão:** 1.0 - Personalizada para cPanel  
**Data:** Agosto 2025  
**Configurações:** tremedal_ged_db1 / tremedal_ged / G7d875@#  

---

## 📋 Índice

1. [Pré-requisitos](#pré-requisitos)
2. [Configuração do Banco de Dados no cPanel](#configuração-do-banco-de-dados-no-cpanel)
3. [Upload dos Arquivos](#upload-dos-arquivos)
4. [Configuração de Permissões](#configuração-de-permissões)
5. [Instalação Automatizada](#instalação-automatizada)
6. [Verificação e Testes](#verificação-e-testes)
7. [Configurações Avançadas](#configurações-avançadas)
8. [Solução de Problemas](#solução-de-problemas)

---

## 🎯 Pré-requisitos

### Servidor cPanel:
- ✅ **PHP 7.4+** (recomendado PHP 8.0+)
- ✅ **MySQL 5.7+** ou **MariaDB 10.3+**
- ✅ **Extensões PHP:** mysqli, pdo, pdo_mysql, mbstring, json, session
- ✅ **Espaço em disco:** Mínimo 500MB
- ✅ **Acesso ao cPanel** com permissões para criar bancos de dados

### Configurações Personalizadas:
```
Database: tremedal_ged_db1
Username: tremedal_ged
Password: G7d875@#
```

---


## 🗄️ Configuração do Banco de Dados no cPanel

### Passo 1: Criar o Banco de Dados

1. **Acesse o cPanel** da sua hospedagem
2. **Localize a seção "Bancos de Dados"**
3. **Clique em "Bancos de Dados MySQL"**
4. **Criar novo banco:**
   ```
   Nome do Banco: tremedal_ged_db1
   ```
   - Digite: `tremedal_ged_db1`
   - Clique em "Criar Banco de Dados"

### Passo 2: Criar Usuário do Banco

1. **Na mesma página, seção "Usuários MySQL"**
2. **Criar novo usuário:**
   ```
   Nome de Usuário: tremedal_ged
   Senha: G7d875@#
   ```
   - Digite o nome de usuário: `tremedal_ged`
   - Digite a senha: `G7d875@#`
   - Confirme a senha: `G7d875@#`
   - Clique em "Criar Usuário"

### Passo 3: Associar Usuário ao Banco

1. **Na seção "Adicionar Usuário ao Banco de Dados"**
2. **Selecionar:**
   - Usuário: `tremedal_ged`
   - Banco de Dados: `tremedal_ged_db1`
3. **Clique em "Adicionar"**
4. **Marcar TODAS as permissões** (ou selecionar "TODOS OS PRIVILÉGIOS")
5. **Clique em "Fazer Alterações"**

### Passo 4: Importar Estrutura do Banco

1. **Acesse "phpMyAdmin"** no cPanel
2. **Selecione o banco** `tremedal_ged_db1`
3. **Clique na aba "Importar"**
4. **Escolha o arquivo** `setup_database_cpanel.sql`
5. **Clique em "Executar"**

**✅ Resultado esperado:** Mensagem de sucesso e 12 tabelas criadas

### Verificação da Configuração:

```sql
-- Execute no phpMyAdmin para verificar:
SHOW TABLES;
SELECT * FROM user WHERE username = 'admin';
```

**Saída esperada:**
- 12 tabelas listadas
- 1 usuário admin encontrado

---


## ✅ Verificação e Testes

### Passo 1: Primeiro Acesso

1. **Acesse o sistema:** `https://seudominio.com/ged/`
2. **Será redirecionado para:** `login.php`
3. **Use as credenciais:**
   ```
   Usuário: admin
   Senha: admin123
   ```

### Passo 2: Verificar Dashboard

**Após o login, você deve ver:**
- ✅ Dashboard com estatísticas
- ✅ Menu de navegação funcionando
- ✅ Contadores de usuários, categorias, documentos
- ✅ Links para funcionalidades principais

### Passo 3: Testar Funcionalidades Básicas

**1. Gerenciar Categorias:**
- Acesse "Categorias"
- Verifique se as 10 categorias padrão estão listadas
- Teste criar uma nova categoria

**2. Gerenciar Usuários:**
- Acesse "Usuários"
- Verifique se o usuário admin está listado
- Teste criar um novo usuário

**3. Upload de Documentos:**
- Acesse "Documentos" → "Adicionar"
- Teste fazer upload de um arquivo pequeno
- Verifique se aparece na listagem

**4. Sistema de Pesquisa:**
- Use a barra de pesquisa
- Teste buscar por documentos ou categorias

### Passo 4: Verificar Logs

1. **Acesse "Logs de Auditoria"**
2. **Deve mostrar:**
   - Login do administrador
   - Ações realizadas no sistema
   - Instalação do sistema

### Passo 5: Alterar Senha do Admin

**IMPORTANTE - Faça isso imediatamente:**

1. **Acesse "Usuários"**
2. **Clique em "Editar"** no usuário admin
3. **Altere a senha** para uma senha segura
4. **Salve as alterações**

---

## ⚙️ Configurações Avançadas

### Configuração de Email (Opcional)

**Edite o arquivo `config/config.php`:**

```php
// Configurações de email para notificações
define('SMTP_HOST', 'mail.seudominio.com');
define('SMTP_PORT', 587);
define('SMTP_USER', 'noreply@seudominio.com');
define('SMTP_PASS', 'sua_senha_email');
define('SMTP_SECURE', 'tls');
```

### Configuração de Upload

**Ajustar limites de upload no cPanel:**

1. **Acesse "Seletor de Versão PHP"**
2. **Clique em "Opções"**
3. **Ajuste os valores:**
   ```
   upload_max_filesize = 50M
   post_max_size = 50M
   max_execution_time = 300
   memory_limit = 256M
   ```

### Configuração de SSL/HTTPS

1. **No cPanel, acesse "SSL/TLS"**
2. **Configure certificado SSL**
3. **Force redirecionamento HTTPS**
4. **Teste o acesso via HTTPS**

### Backup Automático

**Criar script de backup (opcional):**

```bash
#!/bin/bash
# Backup do Sistema GED
DATE=$(date +%Y%m%d_%H%M%S)
BACKUP_DIR="/home/usuario/backups"

# Backup do banco
mysqldump -u tremedal_ged -p'G7d875@#' tremedal_ged_db1 > $BACKUP_DIR/ged_db_$DATE.sql

# Backup dos arquivos
tar -czf $BACKUP_DIR/ged_files_$DATE.tar.gz /public_html/ged/uploads/
```

---

## 🔧 Solução de Problemas

### Problema: "Erro de conexão com banco de dados"

**Possíveis causas e soluções:**

1. **Credenciais incorretas:**
   - Verifique `config/database.php`
   - Confirme: tremedal_ged_db1, tremedal_ged, G7d875@#

2. **Banco não criado:**
   - Acesse cPanel → Bancos de Dados MySQL
   - Verifique se `tremedal_ged_db1` existe

3. **Usuário sem permissões:**
   - Verifique se `tremedal_ged` tem acesso ao banco
   - Re-associe o usuário ao banco com todas as permissões

### Problema: "Página não encontrada" (404)

**Soluções:**

1. **Verificar URL:**
   - Confirme: `https://seudominio.com/ged/`
   - Verifique se os arquivos estão no diretório correto

2. **Verificar .htaccess:**
   - Confirme se o arquivo `.htaccess` foi enviado
   - Verifique se mod_rewrite está ativo

### Problema: "Erro de upload de arquivo"

**Soluções:**

1. **Verificar permissões:**
   ```bash
   chmod 755 uploads/
   ```

2. **Verificar limites PHP:**
   - Acesse cPanel → Seletor PHP → Opções
   - Aumente `upload_max_filesize` e `post_max_size`

3. **Verificar espaço em disco:**
   - Verifique se há espaço suficiente na conta

### Problema: "Sessão expirada constantemente"

**Soluções:**

1. **Configurar sessões PHP:**
   ```php
   // No arquivo config/config.php
   ini_set('session.gc_maxlifetime', 3600);
   ini_set('session.cookie_lifetime', 3600);
   ```

2. **Verificar permissões de sessão:**
   - Confirme se o diretório de sessões tem permissão de escrita

### Logs de Erro

**Verificar logs de erro:**

1. **cPanel → Logs de Erro**
2. **Arquivo:** `/public_html/ged/logs/error.log`
3. **PHP Error Log** do servidor

---

## 📞 Suporte e Manutenção

### Informações do Sistema

```
Versão: 1.0 - cPanel Edition
Database: tremedal_ged_db1
Username: tremedal_ged
Password: G7d875@#
Admin User: admin
Admin Pass: admin123 (ALTERE IMEDIATAMENTE)
```

### Manutenção Regular

**Semanal:**
- [ ] Verificar logs de erro
- [ ] Backup do banco de dados
- [ ] Verificar espaço em disco

**Mensal:**
- [ ] Backup completo dos arquivos
- [ ] Limpeza de logs antigos
- [ ] Verificar atualizações de segurança

### Checklist de Instalação Completa

- [ ] Banco de dados criado (tremedal_ged_db1)
- [ ] Usuário do banco criado (tremedal_ged)
- [ ] Permissões do banco configuradas
- [ ] Script SQL importado com sucesso
- [ ] Arquivos PHP enviados para o servidor
- [ ] Permissões de diretórios configuradas (755)
- [ ] Diretórios uploads/ e logs/ criados
- [ ] Script install_cpanel.php executado com sucesso
- [ ] Login realizado com admin/admin123
- [ ] Senha do admin alterada
- [ ] Funcionalidades básicas testadas
- [ ] SSL/HTTPS configurado (recomendado)
- [ ] Backup configurado

---

## 🎉 Conclusão

**Parabéns! Seu Sistema GED está instalado e funcionando!**

### URLs Importantes:
- **Sistema:** `https://seudominio.com/ged/`
- **Login:** `https://seudominio.com/ged/login.php`
- **Dashboard:** `https://seudominio.com/ged/dashboard.php`
- **Verificação:** `https://seudominio.com/ged/install_cpanel.php`

### Próximos Passos:
1. ✅ Alterar senha do administrador
2. ✅ Configurar categorias específicas da sua empresa
3. ✅ Criar usuários adicionais
4. ✅ Configurar workflows de aprovação
5. ✅ Fazer backup inicial
6. ✅ Treinar usuários no sistema

**O Sistema GED está pronto para uso profissional em seu servidor cPanel!**

---

*Manual criado especificamente para instalação em servidor cPanel com as configurações personalizadas solicitadas.*

