-- =====================================================
-- SCRIPT DE INSTALAÇÃO - SISTEMA GED PARA CPANEL
-- =====================================================
-- Database: tremedal_ged_db1
-- User: tremedal_ged
-- Password: G7d875@#
-- =====================================================

-- IMPORTANTE: Execute este script no phpMyAdmin do cPanel
-- ou através da linha de comando MySQL

USE tremedal_ged_db1;

-- =====================================================
-- CRIAÇÃO DAS TABELAS
-- =====================================================

-- Tabela de usuários
CREATE TABLE IF NOT EXISTS `user` (
    `id` int(11) NOT NULL AUTO_INCREMENT,
    `username` varchar(50) NOT NULL UNIQUE,
    `email` varchar(100) NOT NULL UNIQUE,
    `password_hash` varchar(255) NOT NULL,
    `full_name` varchar(100) NOT NULL,
    `role` enum('admin','manager','user') DEFAULT 'user',
    `is_active` tinyint(1) DEFAULT 1,
    `created_at` timestamp DEFAULT CURRENT_TIMESTAMP,
    `updated_at` timestamp DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabela de categorias
CREATE TABLE IF NOT EXISTS `category` (
    `id` int(11) NOT NULL AUTO_INCREMENT,
    `name` varchar(100) NOT NULL,
    `description` text,
    `color` varchar(7) DEFAULT '#007bff',
    `is_active` tinyint(1) DEFAULT 1,
    `created_by` int(11),
    `created_at` timestamp DEFAULT CURRENT_TIMESTAMP,
    `updated_at` timestamp DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    PRIMARY KEY (`id`),
    FOREIGN KEY (`created_by`) REFERENCES `user`(`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabela de documentos
CREATE TABLE IF NOT EXISTS `document` (
    `id` int(11) NOT NULL AUTO_INCREMENT,
    `title` varchar(255) NOT NULL,
    `description` text,
    `file_name` varchar(255) NOT NULL,
    `file_path` varchar(500) NOT NULL,
    `file_size` bigint(20) NOT NULL,
    `file_type` varchar(100) NOT NULL,
    `category_id` int(11),
    `uploaded_by` int(11),
    `status` enum('active','archived','deleted') DEFAULT 'active',
    `version` int(11) DEFAULT 1,
    `tags` text,
    `is_public` tinyint(1) DEFAULT 0,
    `download_count` int(11) DEFAULT 0,
    `created_at` timestamp DEFAULT CURRENT_TIMESTAMP,
    `updated_at` timestamp DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    PRIMARY KEY (`id`),
    FOREIGN KEY (`category_id`) REFERENCES `category`(`id`) ON DELETE SET NULL,
    FOREIGN KEY (`uploaded_by`) REFERENCES `user`(`id`) ON DELETE SET NULL,
    INDEX `idx_status` (`status`),
    INDEX `idx_category` (`category_id`),
    INDEX `idx_uploaded_by` (`uploaded_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabela de permissões
CREATE TABLE IF NOT EXISTS `permission` (
    `id` int(11) NOT NULL AUTO_INCREMENT,
    `name` varchar(100) NOT NULL UNIQUE,
    `description` text,
    `module` varchar(50) NOT NULL,
    `action` varchar(50) NOT NULL,
    `created_at` timestamp DEFAULT CURRENT_TIMESTAMP,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabela de permissões de usuário
CREATE TABLE IF NOT EXISTS `user_permission` (
    `id` int(11) NOT NULL AUTO_INCREMENT,
    `user_id` int(11) NOT NULL,
    `permission_id` int(11) NOT NULL,
    `granted_by` int(11),
    `granted_at` timestamp DEFAULT CURRENT_TIMESTAMP,
    PRIMARY KEY (`id`),
    UNIQUE KEY `unique_user_permission` (`user_id`, `permission_id`),
    FOREIGN KEY (`user_id`) REFERENCES `user`(`id`) ON DELETE CASCADE,
    FOREIGN KEY (`permission_id`) REFERENCES `permission`(`id`) ON DELETE CASCADE,
    FOREIGN KEY (`granted_by`) REFERENCES `user`(`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabela de workflows
CREATE TABLE IF NOT EXISTS `workflow` (
    `id` int(11) NOT NULL AUTO_INCREMENT,
    `name` varchar(100) NOT NULL,
    `description` text,
    `steps` text NOT NULL,
    `is_active` tinyint(1) DEFAULT 1,
    `created_by` int(11),
    `created_at` timestamp DEFAULT CURRENT_TIMESTAMP,
    `updated_at` timestamp DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    PRIMARY KEY (`id`),
    FOREIGN KEY (`created_by`) REFERENCES `user`(`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabela de steps do workflow
CREATE TABLE IF NOT EXISTS `workflow_step` (
    `id` int(11) NOT NULL AUTO_INCREMENT,
    `workflow_id` int(11) NOT NULL,
    `step_order` int(11) NOT NULL,
    `step_name` varchar(100) NOT NULL,
    `step_description` text,
    `assigned_to` int(11),
    `required` tinyint(1) DEFAULT 1,
    `created_at` timestamp DEFAULT CURRENT_TIMESTAMP,
    PRIMARY KEY (`id`),
    FOREIGN KEY (`workflow_id`) REFERENCES `workflow`(`id`) ON DELETE CASCADE,
    FOREIGN KEY (`assigned_to`) REFERENCES `user`(`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabela de aprovações do workflow
CREATE TABLE IF NOT EXISTS `workflow_approval` (
    `id` int(11) NOT NULL AUTO_INCREMENT,
    `document_id` int(11) NOT NULL,
    `workflow_id` int(11) NOT NULL,
    `step_id` int(11) NOT NULL,
    `approved_by` int(11),
    `status` enum('pending','approved','rejected') DEFAULT 'pending',
    `comments` text,
    `approved_at` timestamp NULL,
    `created_at` timestamp DEFAULT CURRENT_TIMESTAMP,
    PRIMARY KEY (`id`),
    FOREIGN KEY (`document_id`) REFERENCES `document`(`id`) ON DELETE CASCADE,
    FOREIGN KEY (`workflow_id`) REFERENCES `workflow`(`id`) ON DELETE CASCADE,
    FOREIGN KEY (`step_id`) REFERENCES `workflow_step`(`id`) ON DELETE CASCADE,
    FOREIGN KEY (`approved_by`) REFERENCES `user`(`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabela de versões de documentos
CREATE TABLE IF NOT EXISTS `document_version` (
    `id` int(11) NOT NULL AUTO_INCREMENT,
    `document_id` int(11) NOT NULL,
    `version_number` int(11) NOT NULL,
    `file_name` varchar(255) NOT NULL,
    `file_path` varchar(500) NOT NULL,
    `file_size` bigint(20) NOT NULL,
    `changes_description` text,
    `created_by` int(11),
    `created_at` timestamp DEFAULT CURRENT_TIMESTAMP,
    PRIMARY KEY (`id`),
    FOREIGN KEY (`document_id`) REFERENCES `document`(`id`) ON DELETE CASCADE,
    FOREIGN KEY (`created_by`) REFERENCES `user`(`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabela de palavras-chave dos documentos
CREATE TABLE IF NOT EXISTS `document_keywords` (
    `id` int(11) NOT NULL AUTO_INCREMENT,
    `document_id` int(11) NOT NULL,
    `keyword` varchar(100) NOT NULL,
    `created_at` timestamp DEFAULT CURRENT_TIMESTAMP,
    PRIMARY KEY (`id`),
    FOREIGN KEY (`document_id`) REFERENCES `document`(`id`) ON DELETE CASCADE,
    INDEX `idx_keyword` (`keyword`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabela de logs de auditoria
CREATE TABLE IF NOT EXISTS `audit_log` (
    `id` int(11) NOT NULL AUTO_INCREMENT,
    `user_id` int(11),
    `action` varchar(100) NOT NULL,
    `table_name` varchar(50),
    `record_id` int(11),
    `old_values` text,
    `new_values` text,
    `ip_address` varchar(45),
    `user_agent` text,
    `created_at` timestamp DEFAULT CURRENT_TIMESTAMP,
    PRIMARY KEY (`id`),
    FOREIGN KEY (`user_id`) REFERENCES `user`(`id`) ON DELETE SET NULL,
    INDEX `idx_user_id` (`user_id`),
    INDEX `idx_action` (`action`),
    INDEX `idx_created_at` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- =====================================================
-- INSERÇÃO DE DADOS INICIAIS
-- =====================================================

-- Inserir usuário administrador
INSERT INTO `user` (`username`, `email`, `password_hash`, `full_name`, `role`, `is_active`) 
VALUES ('admin', 'admin@tremedal.com', '$2y$10$EIQo2geseDoOvXoApkCW2uZ2zGB6LjIhr/PTiGmjJVzIHJQ4/FeFy', 'Administrador do Sistema', 'admin', 1)
ON DUPLICATE KEY UPDATE 
    `password_hash` = '$2y$10$EIQo2geseDoOvXoApkCW2uZ2zGB6LjIhr/PTiGmjJVzIHJQ4/FeFy',
    `email` = 'admin@tremedal.com',
    `full_name` = 'Administrador do Sistema';

-- Inserir permissões básicas
INSERT INTO `permission` (`name`, `description`, `module`, `action`) VALUES
('user_create', 'Criar usuários', 'user', 'create'),
('user_read', 'Visualizar usuários', 'user', 'read'),
('user_update', 'Editar usuários', 'user', 'update'),
('user_delete', 'Excluir usuários', 'user', 'delete'),
('document_create', 'Criar documentos', 'document', 'create'),
('document_read', 'Visualizar documentos', 'document', 'read'),
('document_update', 'Editar documentos', 'document', 'update'),
('document_delete', 'Excluir documentos', 'document', 'delete'),
('category_manage', 'Gerenciar categorias', 'category', 'manage'),
('workflow_manage', 'Gerenciar workflows', 'workflow', 'manage'),
('audit_read', 'Visualizar logs de auditoria', 'audit', 'read'),
('system_admin', 'Administração do sistema', 'system', 'admin')
ON DUPLICATE KEY UPDATE 
    `description` = VALUES(`description`),
    `module` = VALUES(`module`),
    `action` = VALUES(`action`);

-- Conceder todas as permissões ao usuário admin
INSERT INTO `user_permission` (`user_id`, `permission_id`, `granted_by`)
SELECT 1, `id`, 1 FROM `permission`
ON DUPLICATE KEY UPDATE `granted_at` = CURRENT_TIMESTAMP;

-- Inserir categorias padrão
INSERT INTO `category` (`name`, `description`, `color`, `created_by`) VALUES
('Documentos Gerais', 'Documentos diversos e gerais', '#007bff', 1),
('Contratos', 'Contratos e acordos', '#28a745', 1),
('Relatórios', 'Relatórios e análises', '#ffc107', 1),
('Financeiro', 'Documentos financeiros', '#dc3545', 1),
('Recursos Humanos', 'Documentos de RH', '#6f42c1', 1),
('Jurídico', 'Documentos jurídicos', '#fd7e14', 1),
('Marketing', 'Materiais de marketing', '#e83e8c', 1),
('Técnico', 'Documentação técnica', '#20c997', 1),
('Políticas', 'Políticas e procedimentos', '#6c757d', 1),
('Arquivo Morto', 'Documentos arquivados', '#343a40', 1)
ON DUPLICATE KEY UPDATE 
    `description` = VALUES(`description`),
    `color` = VALUES(`color`);

-- Inserir workflow padrão
INSERT INTO `workflow` (`name`, `description`, `steps`, `created_by`) VALUES
('Aprovação Simples', 'Workflow básico de aprovação de documentos', 'Revisão,Aprovação,Publicação', 1),
('Aprovação Dupla', 'Workflow com dupla aprovação', 'Revisão Técnica,Aprovação Gerencial,Aprovação Final,Publicação', 1)
ON DUPLICATE KEY UPDATE 
    `description` = VALUES(`description`),
    `steps` = VALUES(`steps`);

-- =====================================================
-- CONFIGURAÇÕES FINAIS
-- =====================================================

-- Registrar instalação no log de auditoria
INSERT INTO `audit_log` (`user_id`, `action`, `table_name`, `record_id`, `new_values`, `ip_address`) 
VALUES (1, 'SYSTEM_INSTALL', 'system', 1, 'Sistema GED instalado com sucesso para cPanel', '127.0.0.1');

-- =====================================================
-- VERIFICAÇÕES FINAIS
-- =====================================================

-- Verificar se todas as tabelas foram criadas
SELECT 
    TABLE_NAME as 'Tabela Criada',
    TABLE_ROWS as 'Registros'
FROM information_schema.TABLES 
WHERE TABLE_SCHEMA = 'tremedal_ged_db1' 
ORDER BY TABLE_NAME;

-- Verificar usuário admin
SELECT 
    id,
    username,
    email,
    full_name,
    role,
    is_active,
    created_at
FROM user WHERE username = 'admin';

-- Verificar permissões do admin
SELECT 
    u.username,
    p.name as permission_name,
    p.description,
    p.module,
    p.action
FROM user u
JOIN user_permission up ON u.id = up.user_id
JOIN permission p ON up.permission_id = p.id
WHERE u.username = 'admin'
ORDER BY p.module, p.action;

-- =====================================================
-- SCRIPT CONCLUÍDO
-- =====================================================
-- 
-- PRÓXIMOS PASSOS:
-- 1. Copie os arquivos PHP para o diretório público do cPanel
-- 2. Configure as permissões dos diretórios (uploads, logs)
-- 3. Acesse install_cpanel.php para verificar a instalação
-- 4. Faça login com admin/admin123
-- 5. Altere a senha do administrador
-- 
-- CREDENCIAIS DE ACESSO:
-- Usuário: admin
-- Senha: admin123
-- 
-- CONFIGURAÇÕES DO BANCO:
-- Host: localhost
-- Database: tremedal_ged_db1
-- Username: tremedal_ged
-- Password: G7d875@#
-- 
-- =====================================================

