# Manual de Instalação - Sistema GED
## Gerenciamento Eletrônico de Documentos

**Versão:** 1.0  
**Data:** Agosto 2025  
**Desenvolvido por:** Manus AI  

---

## 📋 Índice

1. [Introdução](#introdução)
2. [Requisitos do Sistema](#requisitos-do-sistema)
3. [Instalação Passo a Passo](#instalação-passo-a-passo)
4. [Configuração do Banco de Dados](#configuração-do-banco-de-dados)
5. [Configuração do Servidor Web](#configuração-do-servidor-web)
6. [Primeiro Acesso](#primeiro-acesso)
7. [Configurações Avançadas](#configurações-avançadas)
8. [Solução de Problemas](#solução-de-problemas)
9. [Manutenção e Backup](#manutenção-e-backup)
10. [Suporte](#suporte)

---

## 🎯 Introdução

O Sistema GED (Gerenciamento Eletrônico de Documentos) é uma solução completa para organização, armazenamento e controle de documentos digitais. Este manual fornece instruções detalhadas para instalação e configuração do sistema.

### Funcionalidades Principais:
- ✅ Gerenciamento completo de documentos
- ✅ Sistema de categorização
- ✅ Controle de usuários e permissões
- ✅ Workflows de aprovação
- ✅ Logs de auditoria
- ✅ Sistema de pesquisa avançada
- ✅ Interface responsiva e moderna

---

## 🖥️ Requisitos do Sistema

### Servidor Web:
- **Apache 2.4+** ou **Nginx 1.18+**
- **PHP 7.4+** (recomendado PHP 8.0+)
- **MySQL 5.7+** ou **MariaDB 10.3+**

### Extensões PHP Necessárias:
```bash
php-mysql
php-pdo
php-mbstring
php-json
php-session
php-fileinfo
php-gd (opcional, para manipulação de imagens)
```

### Recursos do Servidor:
- **RAM:** Mínimo 512MB (recomendado 1GB+)
- **Espaço em Disco:** Mínimo 1GB (+ espaço para documentos)
- **Largura de Banda:** Conforme necessidade de usuários

### Permissões:
- Acesso de escrita no diretório de instalação
- Acesso ao MySQL para criação de banco de dados
- Permissões para configurar virtual hosts (se necessário)

---


## 🚀 Instalação Passo a Passo

### Passo 1: Download e Extração

1. **Baixe o arquivo `sistema_ged_completo.zip`**
2. **Extraia o conteúdo** em seu servidor web:
   ```bash
   unzip sistema_ged_completo.zip
   cd ged_php/
   ```

3. **Mova os arquivos** para o diretório do servidor web:
   ```bash
   # Para Apache (Ubuntu/Debian)
   sudo cp -r ged_php/* /var/www/html/ged/
   
   # Para Apache (CentOS/RHEL)
   sudo cp -r ged_php/* /var/www/html/ged/
   
   # Para Nginx
   sudo cp -r ged_php/* /usr/share/nginx/html/ged/
   ```

### Passo 2: Configuração de Permissões

```bash
# Definir proprietário correto
sudo chown -R www-data:www-data /var/www/html/ged/

# Configurar permissões de diretórios
sudo find /var/www/html/ged/ -type d -exec chmod 755 {} \;

# Configurar permissões de arquivos
sudo find /var/www/html/ged/ -type f -exec chmod 644 {} \;

# Permissões especiais para uploads e logs
sudo chmod 755 /var/www/html/ged/uploads/
sudo chmod 755 /var/www/html/ged/logs/
```

### Passo 3: Instalação de Dependências PHP

#### Ubuntu/Debian:
```bash
sudo apt update
sudo apt install apache2 mysql-server php php-mysql php-mbstring php-json php-session
sudo systemctl enable apache2 mysql
sudo systemctl start apache2 mysql
```

#### CentOS/RHEL:
```bash
sudo yum update
sudo yum install httpd mariadb-server php php-mysql php-mbstring php-json
sudo systemctl enable httpd mariadb
sudo systemctl start httpd mariadb
```

---

## 🗄️ Configuração do Banco de Dados

### Passo 1: Criar Banco de Dados

1. **Acesse o MySQL:**
   ```bash
   sudo mysql -u root -p
   ```

2. **Execute os comandos SQL:**
   ```sql
   CREATE DATABASE ged_db1 CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
   CREATE USER 'ged_user'@'localhost' IDENTIFIED BY 'senha_segura_aqui';
   GRANT ALL PRIVILEGES ON ged_db1.* TO 'ged_user'@'localhost';
   FLUSH PRIVILEGES;
   EXIT;
   ```

### Passo 2: Importar Estrutura do Banco

```bash
# Importar estrutura principal
mysql -u ged_user -p ged_db1 < ged_package/database/setup.sql

# Aplicar correções (se necessário)
mysql -u ged_user -p ged_db1 < correcoes_banco_dados.sql
```

### Passo 3: Configurar Conexão

1. **Edite o arquivo de configuração:**
   ```bash
   nano /var/www/html/ged/config/database.php
   ```

2. **Atualize as credenciais:**
   ```php
   private $host = "localhost";
   private $db_name = "ged_db1";
   private $username = "ged_user";
   private $password = "senha_segura_aqui";
   ```

### Passo 4: Executar Script de Configuração

```bash
cd /var/www/html/ged/
php setup_production.php
```

**Saída esperada:**
```
✓ Conexão com banco de dados estabelecida
✓ Usuário admin encontrado
✓ Senha do admin atualizada (__REMOVED_PASSWORD__)
✓ Permissões verificadas e atualizadas
✓ Sistema configurado com sucesso para produção!
```

---


## 🌐 Configuração do Servidor Web

### Apache Virtual Host

1. **Crie um arquivo de configuração:**
   ```bash
   sudo nano /etc/apache2/sites-available/ged.conf
   ```

2. **Adicione a configuração:**
   ```apache
   <VirtualHost *:80>
       ServerName ged.seudominio.com
       DocumentRoot /var/www/html/ged
       
       <Directory /var/www/html/ged>
           AllowOverride All
           Require all granted
       </Directory>
       
       # Logs
       ErrorLog ${APACHE_LOG_DIR}/ged_error.log
       CustomLog ${APACHE_LOG_DIR}/ged_access.log combined
       
       # Segurança adicional
       <Directory /var/www/html/ged/config>
           Require all denied
       </Directory>
       
       <Directory /var/www/html/ged/logs>
           Require all denied
       </Directory>
   </VirtualHost>
   ```

3. **Ativar o site:**
   ```bash
   sudo a2ensite ged.conf
   sudo a2enmod rewrite
   sudo systemctl reload apache2
   ```

### Nginx Configuration

1. **Crie um arquivo de configuração:**
   ```bash
   sudo nano /etc/nginx/sites-available/ged
   ```

2. **Adicione a configuração:**
   ```nginx
   server {
       listen 80;
       server_name ged.seudominio.com;
       root /usr/share/nginx/html/ged;
       index index.php index.html;
       
       location / {
           try_files $uri $uri/ /index.php?$query_string;
       }
       
       location ~ \.php$ {
           fastcgi_pass unix:/var/run/php/php8.0-fpm.sock;
           fastcgi_index index.php;
           fastcgi_param SCRIPT_FILENAME $document_root$fastcgi_script_name;
           include fastcgi_params;
       }
       
       # Segurança
       location ~ /config/ {
           deny all;
       }
       
       location ~ /logs/ {
           deny all;
       }
       
       # Logs
       access_log /var/log/nginx/ged_access.log;
       error_log /var/log/nginx/ged_error.log;
   }
   ```

3. **Ativar o site:**
   ```bash
   sudo ln -s /etc/nginx/sites-available/ged /etc/nginx/sites-enabled/
   sudo nginx -t
   sudo systemctl reload nginx
   ```

### SSL/HTTPS (Recomendado)

#### Com Let's Encrypt (Certbot):
```bash
# Instalar Certbot
sudo apt install certbot python3-certbot-apache  # Para Apache
sudo apt install certbot python3-certbot-nginx   # Para Nginx

# Obter certificado
sudo certbot --apache -d ged.seudominio.com      # Para Apache
sudo certbot --nginx -d ged.seudominio.com       # Para Nginx
```

---

## 🔐 Primeiro Acesso

### Credenciais Padrão:
- **URL:** `http://seudominio.com/ged/` ou `http://localhost/ged/`
- **Usuário:** `admin`
- **Senha:** `__REMOVED_PASSWORD__`

### Passos do Primeiro Acesso:

1. **Acesse o sistema** através do navegador
2. **Faça login** com as credenciais padrão
3. **Altere a senha** do administrador:
   - Vá em "Usuários" → "Editar Perfil"
   - Defina uma senha forte
4. **Configure as categorias** iniciais
5. **Crie usuários** adicionais conforme necessário
6. **Teste o upload** de documentos

### Verificação da Instalação:

✅ **Dashboard carrega corretamente**  
✅ **Login funciona**  
✅ **Estatísticas são exibidas**  
✅ **Menu de navegação responde**  
✅ **Upload de documentos funciona**  

---


## ⚙️ Configurações Avançadas

### Configuração de Upload

1. **Edite o arquivo PHP.ini:**
   ```bash
   sudo nano /etc/php/8.0/apache2/php.ini
   ```

2. **Ajuste os valores:**
   ```ini
   upload_max_filesize = 50M
   post_max_size = 50M
   max_execution_time = 300
   max_input_time = 300
   memory_limit = 256M
   ```

3. **Reinicie o servidor web:**
   ```bash
   sudo systemctl restart apache2  # ou nginx
   ```

### Configuração de Email (Opcional)

Para notificações por email, edite `config/config.php`:
```php
// Configurações de email
define('SMTP_HOST', 'smtp.seudominio.com');
define('SMTP_PORT', 587);
define('SMTP_USER', 'noreply@seudominio.com');
define('SMTP_PASS', 'senha_email');
```

### Backup Automático

1. **Crie script de backup:**
   ```bash
   sudo nano /usr/local/bin/backup_ged.sh
   ```

2. **Conteúdo do script:**
   ```bash
   #!/bin/bash
   DATE=$(date +%Y%m%d_%H%M%S)
   BACKUP_DIR="/backup/ged"
   
   # Criar diretório se não existir
   mkdir -p $BACKUP_DIR
   
   # Backup do banco de dados
   mysqldump -u ged_user -p'senha_segura_aqui' ged_db1 > $BACKUP_DIR/ged_db_$DATE.sql
   
   # Backup dos arquivos
   tar -czf $BACKUP_DIR/ged_files_$DATE.tar.gz /var/www/html/ged/uploads/
   
   # Manter apenas últimos 7 backups
   find $BACKUP_DIR -name "ged_*" -mtime +7 -delete
   ```

3. **Configurar cron:**
   ```bash
   sudo crontab -e
   # Adicionar linha para backup diário às 2h
   0 2 * * * /usr/local/bin/backup_ged.sh
   ```

---

## 🔧 Solução de Problemas

### Problema: "Página não encontrada" (404)

**Causa:** Configuração incorreta do servidor web  
**Solução:**
1. Verificar se o mod_rewrite está ativo (Apache)
2. Verificar configuração do virtual host
3. Verificar permissões de arquivo

```bash
# Apache
sudo a2enmod rewrite
sudo systemctl restart apache2

# Verificar permissões
sudo chown -R www-data:www-data /var/www/html/ged/
```

### Problema: "Erro de conexão com banco de dados"

**Causa:** Credenciais incorretas ou serviço MySQL parado  
**Solução:**
1. Verificar se MySQL está rodando:
   ```bash
   sudo systemctl status mysql
   sudo systemctl start mysql
   ```

2. Testar conexão:
   ```bash
   mysql -u ged_user -p ged_db1
   ```

3. Verificar configuração em `config/database.php`

### Problema: "Erro de upload de arquivo"

**Causa:** Limites PHP ou permissões  
**Solução:**
1. Verificar configurações PHP:
   ```bash
   php -i | grep upload_max_filesize
   php -i | grep post_max_size
   ```

2. Verificar permissões do diretório uploads:
   ```bash
   sudo chmod 755 /var/www/html/ged/uploads/
   sudo chown www-data:www-data /var/www/html/ged/uploads/
   ```

### Problema: "Sessão expirada constantemente"

**Causa:** Configuração de sessão PHP  
**Solução:**
1. Editar php.ini:
   ```ini
   session.gc_maxlifetime = 3600
   session.cookie_lifetime = 3600
   ```

2. Reiniciar servidor web

### Problema: "Logs de erro não aparecem"

**Causa:** Permissões do diretório de logs  
**Solução:**
```bash
sudo mkdir -p /var/www/html/ged/logs/
sudo chmod 755 /var/www/html/ged/logs/
sudo chown www-data:www-data /var/www/html/ged/logs/
```

### Verificação de Logs

**Logs do Sistema:**
```bash
# Logs do Apache
sudo tail -f /var/log/apache2/ged_error.log

# Logs do PHP
sudo tail -f /var/log/php/error.log

# Logs do MySQL
sudo tail -f /var/log/mysql/error.log
```

**Logs do GED:**
```bash
# Logs da aplicação
tail -f /var/www/html/ged/logs/error.log
```

---

## 💾 Manutenção e Backup

### Backup Manual

**Banco de Dados:**
```bash
mysqldump -u ged_user -p ged_db1 > backup_ged_$(date +%Y%m%d).sql
```

**Arquivos:**
```bash
tar -czf backup_ged_files_$(date +%Y%m%d).tar.gz /var/www/html/ged/uploads/
```

### Restauração

**Banco de Dados:**
```bash
mysql -u ged_user -p ged_db1 < backup_ged_20250807.sql
```

**Arquivos:**
```bash
tar -xzf backup_ged_files_20250807.tar.gz -C /
```

### Manutenção Regular

1. **Limpeza de logs antigos** (mensal)
2. **Verificação de espaço em disco** (semanal)
3. **Backup completo** (diário)
4. **Teste de restauração** (mensal)
5. **Atualização de segurança** (conforme necessário)

### Monitoramento

**Verificar espaço em disco:**
```bash
df -h /var/www/html/ged/
```

**Verificar uso de memória:**
```bash
free -h
```

**Verificar processos:**
```bash
ps aux | grep apache2
ps aux | grep mysql
```

---

## 📞 Suporte

### Informações do Sistema

- **Versão:** 1.0
- **Desenvolvido por:** Manus AI
- **Linguagem:** PHP 7.4+
- **Banco de Dados:** MySQL 5.7+
- **Licença:** Proprietária

### Documentação Adicional

- `relatorio_sistema_ged.md` - Relatório técnico completo
- `instrucoes_sistema_ged.md` - Instruções de uso
- `correcoes_banco_dados.sql` - Scripts de correção

### Logs para Suporte

Ao solicitar suporte, inclua:
1. Versão do PHP: `php -v`
2. Versão do MySQL: `mysql --version`
3. Logs de erro relevantes
4. Descrição detalhada do problema
5. Passos para reproduzir o erro

### Contato

Para suporte técnico ou dúvidas sobre instalação, consulte a documentação fornecida ou entre em contato com o desenvolvedor.

---

## ✅ Checklist de Instalação

- [ ] Requisitos do sistema verificados
- [ ] Arquivos extraídos e copiados
- [ ] Permissões configuradas
- [ ] Banco de dados criado e configurado
- [ ] Servidor web configurado
- [ ] SSL configurado (recomendado)
- [ ] Primeiro acesso realizado
- [ ] Senha do admin alterada
- [ ] Backup configurado
- [ ] Sistema testado e funcionando

**🎉 Parabéns! Seu Sistema GED está instalado e funcionando!**

---

*Este manual foi gerado automaticamente pelo sistema de instalação. Para atualizações, consulte a documentação oficial.*

