# Instruções de Instalação do Sistema GED em cPanel

Este documento contém instruções detalhadas para instalar o Sistema de Gerenciamento Eletrônico de Documentos (GED) em um ambiente de hospedagem cPanel.

## Pré-requisitos

- Hospedagem com cPanel
- Python 3.8 ou superior (verifique se sua hospedagem suporta)
- MySQL 5.7 ou superior
- Acesso SSH (recomendado, mas não obrigatório)
- Domínio configurado (sysged.com.br)

## Passo 1: Upload dos Arquivos

1. Faça login no seu painel cPanel
2. Navegue até o Gerenciador de Arquivos
3. Navegue até a pasta pública do seu domínio (geralmente `public_html`)
4. Crie uma pasta chamada `ged_v1`
5. Faça upload de todos os arquivos deste pacote para a pasta `ged_v1`

## Passo 2: Configuração do Banco de Dados

1. No painel cPanel, acesse "MySQL Databases"
2. Crie um novo banco de dados chamado `ged_db1`
3. Crie um novo usuário para o banco de dados
4. Atribua todas as permissões ao usuário para o banco de dados `ged_db1`
5. Importe o arquivo `database/setup.sql` para o banco de dados:
   - Acesse o phpMyAdmin no cPanel
   - Selecione o banco de dados `ged_db1`
   - Clique na aba "Importar"
   - Selecione o arquivo `database/setup.sql`
   - Clique em "Executar"

## Passo 3: Configuração do Ambiente

1. Crie um arquivo `.env` na pasta `ged_v1` com o seguinte conteúdo:

```
DB_USERNAME=seu_usuario_mysql
DB_PASSWORD=sua_senha_mysql
DB_HOST=localhost
DB_PORT=3306
DB_NAME=ged_db1
SECRET_KEY=chave_secreta_personalizada
JWT_SECRET_KEY=jwt_chave_secreta_personalizada
FLASK_ENV=production
```

2. Substitua `seu_usuario_mysql` e `sua_senha_mysql` pelas credenciais que você criou
3. Substitua as chaves secretas por valores únicos e seguros

## Passo 4: Instalação das Dependências Python

Se você tiver acesso SSH:

1. Conecte-se ao servidor via SSH
2. Navegue até a pasta `ged_v1`
3. Execute o script de instalação:

```bash
chmod +x install.sh
./install.sh
```

Se você não tiver acesso SSH:

1. Verifique se sua hospedagem oferece "Python Selector" ou "Setup Python App" no cPanel
2. Use essa ferramenta para configurar um ambiente Python 3.8+ para a pasta `ged_v1`
3. Configure as dependências listadas em `requirements.txt`

## Passo 5: Configuração do Servidor Web

### Opção 1: Usando Passenger (recomendado se disponível)

1. Crie um arquivo `.htaccess` na pasta `ged_v1` com o seguinte conteúdo:

```
<IfModule mod_passenger.c>
    PassengerEnabled on
    PassengerPython /home/seu_usuario_cpanel/ged_v1/venv/bin/python
    PassengerAppRoot /home/seu_usuario_cpanel/ged_v1
</IfModule>

<IfModule !mod_passenger.c>
    RewriteEngine On
    RewriteCond %{REQUEST_FILENAME} !-f
    RewriteRule ^(.*)$ /passenger_wsgi.py/$1 [QSA,L]
</IfModule>
```

2. Crie um arquivo `passenger_wsgi.py` na pasta `ged_v1`:

```python
import sys
import os

INTERP = os.path.join(os.getcwd(), 'venv', 'bin', 'python')
if sys.executable != INTERP:
    os.execl(INTERP, INTERP, *sys.argv)

sys.path.insert(0, os.getcwd())
from src import create_app

application = create_app()
```

### Opção 2: Usando WSGI

1. Crie um arquivo `.htaccess` na pasta `ged_v1` com o seguinte conteúdo:

```
RewriteEngine On
RewriteCond %{REQUEST_FILENAME} !-f
RewriteRule ^(.*)$ /wsgi.py/$1 [QSA,L]
```

2. Crie um arquivo `wsgi.py` na pasta `ged_v1`:

```python
import sys
import os

# Adicionar o diretório atual ao path
sys.path.insert(0, os.getcwd())

# Ativar ambiente virtual
activate_this = os.path.join(os.getcwd(), 'venv/bin/activate_this.py')
with open(activate_this) as file_:
    exec(file_.read(), dict(__file__=activate_this))

# Importar a aplicação
from src import create_app
application = create_app()
```

## Passo 6: Configuração de Permissões

1. Configure as permissões corretas para os diretórios:

```bash
chmod -R 755 ged_v1
chmod -R 777 ged_v1/src/static/uploads
```

2. Se você não tiver acesso SSH, use o Gerenciador de Arquivos do cPanel para definir as permissões.

## Passo 7: Teste da Instalação

1. Acesse seu domínio no navegador: `https://sysged.com.br`
2. Você deverá ver a página de login do Sistema GED
3. Faça login com as credenciais padrão:
   - Usuário: `admin`
   - Senha: `__REMOVED_PASSWORD__`
4. **IMPORTANTE**: Altere a senha do administrador imediatamente após o primeiro login!

## Solução de Problemas

### Erro 500 - Internal Server Error

- Verifique os logs de erro do Apache no cPanel
- Confirme se as permissões dos arquivos estão corretas
- Verifique se o Python está configurado corretamente

### Erro de Conexão com o Banco de Dados

- Verifique se as credenciais no arquivo `.env` estão corretas
- Confirme se o banco de dados foi criado e as tabelas foram importadas

### Problemas com Upload de Arquivos

- Verifique se o diretório `uploads` tem permissão de escrita (777)
- Confirme se o limite de upload no PHP está configurado adequadamente

## Suporte

Se você encontrar problemas durante a instalação, entre em contato com o suporte técnico.

---

© 2025 Sistema GED. Todos os direitos reservados.
