<?php
/**
 * Dashboard Simplificado - Sistema GED
 */

// Iniciar sessão
session_start();

// Verificar autenticação
if (!isset($_SESSION["user_id"])) {
    header("Location: login.php");
    exit;
}

// Incluir configuração de banco
require_once "config/database.php";

try {
    $database = new Database();
    $db = $database->getConnection();
    
    // Estatísticas básicas
    $stmt = $db->query("SELECT COUNT(*) as count FROM user");
    $total_users = $stmt->fetch()['count'];
    
    $stmt = $db->query("SELECT COUNT(*) as count FROM category");
    $total_categories = $stmt->fetch()['count'];
    
    $stmt = $db->query("SELECT COUNT(*) as count FROM document");
    $total_documents = $stmt->fetch()['count'];
    
    $stmt = $db->query("SELECT COUNT(*) as count FROM audit_log");
    $total_logs = $stmt->fetch()['count'];
    
} catch (Exception $e) {
    $error_message = getenv('APP_ERROR_MESSAGE') . $e->getMessage();
}
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard - Sistema GED</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-color: #f5f5f5;
            color: #333;
        }
        
        .header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 1rem 2rem;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        
        .header h1 {
            font-size: 1.8rem;
            font-weight: 300;
        }
        
        .nav {
            background: white;
            padding: 1rem 2rem;
            box-shadow: 0 2px 5px rgba(0,0,0,0.1);
            margin-bottom: 2rem;
        }
        
        .nav a {
            color: #667eea;
            text-decoration: none;
            margin-right: 2rem;
            font-weight: 500;
            transition: color 0.3s;
        }
        
        .nav a:hover {
            color: #764ba2;
        }
        
        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 2rem;
        }
        
        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 2rem;
            margin-bottom: 3rem;
        }
        
        .stat-card {
            background: white;
            padding: 2rem;
            border-radius: 10px;
            box-shadow: 0 4px 15px rgba(0,0,0,0.1);
            text-align: center;
            transition: transform 0.3s;
        }
        
        .stat-card:hover {
            transform: translateY(-5px);
        }
        
        .stat-number {
            font-size: 3rem;
            font-weight: bold;
            color: #667eea;
            margin-bottom: 0.5rem;
        }
        
        .stat-label {
            color: #666;
            font-size: 1.1rem;
        }
        
        .welcome {
            background: white;
            padding: 2rem;
            border-radius: 10px;
            box-shadow: 0 4px 15px rgba(0,0,0,0.1);
            margin-bottom: 2rem;
        }
        
        .welcome h2 {
            color: #667eea;
            margin-bottom: 1rem;
        }
        
        .actions {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 1rem;
            margin-top: 2rem;
        }
        
        .action-btn {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 1rem;
            text-align: center;
            text-decoration: none;
            border-radius: 8px;
            transition: transform 0.3s;
            font-weight: 500;
        }
        
        .action-btn:hover {
            transform: translateY(-2px);
        }
        
        .footer {
            text-align: center;
            padding: 2rem;
            color: #666;
            margin-top: 3rem;
        }
        
        .error {
            background: #f8d7da;
            color: #721c24;
            padding: 1rem;
            border-radius: 5px;
            margin-bottom: 1rem;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>📁 Sistema GED - Gerenciamento Eletrônico de Documentos</h1>
    </div>
    
    <div class="nav">
        <a href="dashboard.php">Dashboard</a>
        <a href="documents.php">Documentos</a>
        <a href="categories.php">Categorias</a>
        <a href="users.php">Usuários</a>
        <a href="workflows.php">Workflows</a>
        <a href="audit_logs.php">Logs</a>
        <a href="logout.php">Sair</a>
    </div>
    
    <div class="container">
        <?php if (isset($error_message)): ?>
            <div class="error"><?= htmlspecialchars($error_message) ?></div>
        <?php endif; ?>
        
        <div class="welcome">
            <h2>Bem-vindo, <?= htmlspecialchars($_SESSION["full_name"] ?? $_SESSION["username"] ?? "Usuário") ?>!</h2>
            <p>Este é o painel de controle do Sistema GED. Aqui você pode gerenciar documentos, categorias, usuários e muito mais.</p>
        </div>
        
        <div class="stats-grid">
            <div class="stat-card">
                <div class="stat-number"><?= $total_users ?? 0 ?></div>
                <div class="stat-label">Usuários</div>
            </div>
            
            <div class="stat-card">
                <div class="stat-number"><?= $total_categories ?? 0 ?></div>
                <div class="stat-label">Categorias</div>
            </div>
            
            <div class="stat-card">
                <div class="stat-number"><?= $total_documents ?? 0 ?></div>
                <div class="stat-label">Documentos</div>
            </div>
            
            <div class="stat-card">
                <div class="stat-number"><?= $total_logs ?? 0 ?></div>
                <div class="stat-label">Logs de Auditoria</div>
            </div>
        </div>
        
        <div class="actions">
            <a href="document_add.php" class="action-btn">📄 Adicionar Documento</a>
            <a href="categories.php" class="action-btn">📂 Gerenciar Categorias</a>
            <a href="users.php" class="action-btn">👥 Gerenciar Usuários</a>
            <a href="search.php" class="action-btn">🔍 Pesquisar Documentos</a>
        </div>
    </div>
    
    <div class="footer">
        <p>&copy; 2025 Sistema GED - Gerenciamento Eletrônico de Documentos</p>
        <p>Sistema desenvolvido e implantado com sucesso!</p>
    </div>
</body>
</html>

