<?php
/**
 * Página de login
 * Sistema de Gerenciamento Eletrônico de Documentos (GED)
 */

// Iniciar sessão
session_start();

// Verificar se o usuário já está logado
if (isset($_SESSION['user_id'])) {
    header('Location: index.php');
    exit;
}

// Incluir arquivos necessários
require_once 'config/database.php';
require_once 'models/user.php';
require_once 'controllers/auth_controller.php';

// Processar formulário de login
$error = '';
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $username = $_POST['username'] ?? '';
    $password = $_POST['password'] ?? '';
    
    // Validar campos
    if (empty($username) || empty($password)) {
        $error = getenv('APP_ERROR');
    } else {
        // Conectar ao banco de dados
        $database = new Database();
        $db = $database->getConnection();
        
        // Instanciar controlador de autenticação
        $auth_controller = new AuthController();
        
        // Tentar fazer login
        $result = $auth_controller->login($username, $password);
        
        if ($result['success']) {
            // Login bem-sucedido, redirecionar para a página inicial
            header('Location: index.php');
            exit;
        } else {
            $error = $result['message'];
        }
    }
}

// Definir título da página
$page_title = getenv('APP_PAGE_TITLE');
?>
<!DOCTYPE html>
<html lang="pt-BR" data-bs-theme="<?php echo isset($_COOKIE['theme']) ? $_COOKIE['theme'] : 'light'; ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sistema GED - Login</title>
    
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    
    <!-- Custom CSS -->
    <link href="assets/css/style.css" rel="stylesheet">
    
    <style>
        body {
            height: 100vh;
            display: flex;
            align-items: center;
            background-color: #f5f5f5;
        }
        
        .form-signin {
            max-width: 400px;
            padding: 15px;
        }
        
        .form-signin .form-floating:focus-within {
            z-index: 2;
        }
        
        .form-signin input[type="text"] {
            margin-bottom: -1px;
            border-bottom-right-radius: 0;
            border-bottom-left-radius: 0;
        }
        
        .form-signin input[type="password"] {
            margin-bottom: 10px;
            border-top-left-radius: 0;
            border-top-right-radius: 0;
        }
        
        .theme-toggle {
            position: absolute;
            top: 20px;
            right: 20px;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="form-signin w-100 m-auto">
            <div class="card shadow">
                <div class="card-body p-4">
                    <div class="text-center mb-4">
                        <i class="fas fa-file-archive fa-3x text-primary mb-3"></i>
                        <h1 class="h3 mb-3 fw-normal">Sistema GED</h1>
                        <p class="text-muted">Gerenciamento Eletrônico de Documentos</p>
                    </div>
                    
                    <?php if (!empty($error)): ?>
                    <div class="alert alert-danger" role="alert">
                        <i class="fas fa-exclamation-circle me-2"></i> <?php echo $error; ?>
                    </div>
                    <?php endif; ?>
                    
                    <form method="POST" action="login.php">
                        <div class="form-floating">
                            <input type="text" class="form-control" id="username" name="username" placeholder="Nome de usuário" required autofocus>
                            <label for="username">Nome de usuário</label>
                        </div>
                        <div class="form-floating">
                            <input type="password" class="form-control" id="password" name="password" placeholder="Senha" required>
                            <label for="password">Senha</label>
                        </div>
                        
                        <div class="form-check mb-3">
                            <input class="form-check-input" type="checkbox" value="remember-me" id="remember-me" name="remember-me">
                            <label class="form-check-label" for="remember-me">
                                Lembrar de mim
                            </label>
                        </div>
                        
                        <button class="w-100 btn btn-lg btn-primary" type="submit">
                            <i class="fas fa-sign-in-alt me-2"></i> Entrar
                        </button>
                    </form>
                    
                    <div class="text-center mt-3">
                        <a href="forgot_password.php" class="text-decoration-none">Esqueceu a senha?</a>
                    </div>
                </div>
            </div>
            
            <div class="text-center mt-3">
                <p class="text-muted">&copy; <?php echo date('Y'); ?> Sistema de Gerenciamento Eletrônico de Documentos</p>
            </div>
        </div>
    </div>
    
    <!-- Botão para alternar tema -->
    <button class="btn btn-sm btn-outline-secondary theme-toggle" id="toggleTheme">
        <i class="fas <?php echo isset($_COOKIE['theme']) && $_COOKIE['theme'] == 'dark' ? 'fa-sun' : 'fa-moon'; ?>"></i>
    </button>
    
    <!-- Bootstrap JS Bundle with Popper -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    
    <!-- Tema claro/escuro -->
    <script>
        document.getElementById('toggleTheme').addEventListener('click', function(e) {
            e.preventDefault();
            
            // Obter tema atual
            const currentTheme = document.documentElement.getAttribute('data-bs-theme');
            const newTheme = currentTheme === 'dark' ? 'light' : 'dark';
            
            // Atualizar tema
            document.documentElement.setAttribute('data-bs-theme', newTheme);
            
            // Atualizar ícone
            const icon = this.querySelector('i');
            if (newTheme === 'dark') {
                icon.classList.remove('fa-moon');
                icon.classList.add('fa-sun');
            } else {
                icon.classList.remove('fa-sun');
                icon.classList.add('fa-moon');
            }
            
            // Salvar preferência em cookie (válido por 30 dias)
            const date = new Date();
            date.setTime(date.getTime() + (30 * 24 * 60 * 60 * 1000));
            document.cookie = `theme=${newTheme}; expires=${date.toUTCString()}; path=/`;
        });
    </script>
</body>
</html>
