<?php
class UserPermission {
    private $conn;
    private $table_name = getenv('APP_TABLE_NAME');

    public $user_id;
    public $permission_id;

    public function __construct($db) {
        $this->conn = $db;
    }

    public function create() {
        $query = getenv('APP_QUERY') . $this->table_name . "
                SET
                    user_id=:user_id,
                    permission_id=:permission_id";

        $stmt = $this->conn->prepare($query);

        // sanitize
        $this->user_id = htmlspecialchars(strip_tags($this->user_id));
        $this->permission_id = htmlspecialchars(strip_tags($this->permission_id));

        // bind values
        $stmt->bindParam(":user_id", $this->user_id);
        $stmt->bindParam(":permission_id", $this->permission_id);

        if ($stmt->execute()) {
            return true;
        }

        return false;
    }

    public function delete() {
        $query = getenv('APP_QUERY') . $this->table_name . " WHERE user_id = ? AND permission_id = ?";

        $stmt = $this->conn->prepare($query);

        $this->user_id = htmlspecialchars(strip_tags($this->user_id));
        $this->permission_id = htmlspecialchars(strip_tags($this->permission_id));

        $stmt->bindParam(1, $this->user_id);
        $stmt->bindParam(2, $this->permission_id);

        if ($stmt->execute()) {
            return true;
        }

        return false;
    }

    public function readByUserId() {
        $query = getenv('APP_QUERY') . $this->table_name . " up JOIN permission p ON up.permission_id = p.id WHERE up.user_id = ?";

        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(1, $this->user_id);
        $stmt->execute();

        return $stmt;
    }

    public function deleteAllByUserId() {
        $query = getenv('APP_QUERY') . $this->table_name . " WHERE user_id = ?";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(1, $this->user_id);

        if ($stmt->execute()) {
            return true;
        }
        return false;
    }

    public function exists() {
        $query = getenv('APP_QUERY') . $this->table_name . " WHERE user_id = ? AND permission_id = ? LIMIT 0,1";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(1, $this->user_id);
        $stmt->bindParam(2, $this->permission_id);
        $stmt->execute();
        return ($stmt->rowCount() > 0);
    }
}
?>

