<?php
/**
 * Página de pesquisa de documentos
 * Sistema de Gerenciamento Eletrônico de Documentos (GED)
 */

// Iniciar sessão e verificar autenticação
session_start();
if (!isset($_SESSION["user_id"])) {
    header("Location: login.php");
    exit;
}

// Incluir arquivos necessários
require_once "config/database.php";
require_once "models/document.php";
require_once "models/category.php";
require_once "controllers/search_controller.php";

// Conectar ao banco de dados
$database = new Database();
$db = $database->getConnection();

// Instanciar controladores e modelos
$search_controller = new SearchController();
$category = new Category($db);

// Obter categorias para o filtro
$categories = $category->readAll();

// Definir parâmetros de pesquisa
$query = $_GET["query"] ?? "";
$category_id = $_GET["category_id"] ?? "";
$start_date = $_GET["start_date"] ?? "";
$end_date = $_GET["end_date"] ?? "";
$author_id = $_GET["author_id"] ?? "";

// Executar pesquisa
$search_results = $search_controller->searchDocuments([
    "query" => $query,
    "category_id" => $category_id,
    "start_date" => $start_date,
    "end_date" => $end_date,
    "author_id" => $author_id
]);

// Definir título da página
$page_title = getenv('APP_PAGE_TITLE');

// Incluir cabeçalho
include "includes/header.php";
?>

<div class="row mb-4">
    <div class="col-12">
        <h1><i class="fas fa-search me-2"></i> Pesquisa de Documentos</h1>
    </div>
</div>

<div class="card mb-4">
    <div class="card-header">
        <h5 class="mb-0">Filtros de Pesquisa</h5>
    </div>
    <div class="card-body">
        <form method="GET" action="search.php" class="row g-3">
            <div class="col-md-6">
                <label for="query" class="form-label">Termo de Pesquisa</label>
                <input type="text" class="form-control" id="query" name="query" value="<?php echo htmlspecialchars($query); ?>" placeholder="Título, descrição, palavras-chave...">
            </div>
            <div class="col-md-6">
                <label for="category_id" class="form-label">Categoria</label>
                <select class="form-select select2" id="category_id" name="category_id">
                    <option value="">Todas as Categorias</option>
                    <?php foreach ($categories as $cat): ?>
                    <option value="<?php echo $cat["id"]; ?>" <?php echo ($category_id == $cat["id"]) ? "selected" : ""; ?>><?php echo htmlspecialchars($cat["name"]); ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="col-md-4">
                <label for="start_date" class="form-label">Data Inicial</label>
                <input type="date" class="form-control" id="start_date" name="start_date" value="<?php echo htmlspecialchars($start_date); ?>">
            </div>
            <div class="col-md-4">
                <label for="end_date" class="form-label">Data Final</label>
                <input type="date" class="form-control" id="end_date" name="end_date" value="<?php echo htmlspecialchars($end_date); ?>">
            </div>
            <div class="col-md-4">
                <label for="author_id" class="form-label">Autor (ID)</label>
                <input type="number" class="form-control" id="author_id" name="author_id" value="<?php echo htmlspecialchars($author_id); ?>" placeholder="ID do autor">
            </div>
            <div class="col-12">
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-search me-1"></i> Pesquisar
                </button>
                <a href="search.php" class="btn btn-secondary">
                    <i class="fas fa-times me-1"></i> Limpar Filtros
                </a>
            </div>
        </form>
    </div>
</div>

<div class="card">
    <div class="card-header">
        <h5 class="mb-0">Resultados da Pesquisa (<?php echo count($search_results); ?>)</h5>
    </div>
    <div class="card-body">
        <?php if (count($search_results) > 0): ?>
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Título</th>
                        <th>Categoria</th>
                        <th>Autor</th>
                        <th>Data de Upload</th>
                        <th>Status</th>
                        <th>Ações</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($search_results as $doc): ?>
                    <tr>
                        <td><?php echo $doc["id"]; ?></td>
                        <td>
                            <a href="document_view.php?id=<?php echo $doc["id"]; ?>" class="text-decoration-none">
                                <?php echo htmlspecialchars($doc["title"]); ?>
                            </a>
                        </td>
                        <td><?php echo htmlspecialchars($doc["category_name"]); ?></td>
                        <td><?php echo htmlspecialchars($doc["author_name"]); ?></td>
                        <td><?php echo date("d/m/Y H:i", strtotime($doc["created_at"])); ?></td>
                        <td>
                            <?php if ($doc["status"] == "approved"): ?>
                            <span class="badge bg-success">Aprovado</span>
                            <?php elseif ($doc["status"] == "pending"): ?>
                            <span class="badge bg-warning text-dark">Pendente</span>
                            <?php elseif ($doc["status"] == "rejected"): ?>
                            <span class="badge bg-danger">Rejeitado</span>
                            <?php else: ?>
                            <span class="badge bg-secondary">Rascunho</span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <div class="btn-group btn-group-sm">
                                <a href="document_view.php?id=<?php echo $doc["id"]; ?>" class="btn btn-info" title="Visualizar">
                                    <i class="fas fa-eye"></i>
                                </a>
                                <a href="document_edit.php?id=<?php echo $doc["id"]; ?>" class="btn btn-primary" title="Editar">
                                    <i class="fas fa-edit"></i>
                                </a>
                                <a href="document_download.php?id=<?php echo $doc["id"]; ?>" class="btn btn-success" title="Download">
                                    <i class="fas fa-download"></i>
                                </a>
                            </div>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
        <?php else: ?>
        <div class="alert alert-info">
            <i class="fas fa-info-circle me-2"></i> Nenhum documento encontrado com os critérios de pesquisa informados.
        </div>
        <?php endif; ?>
    </div>
</div>

<?php
// Incluir rodapé
include "includes/footer.php";
?>

