from flask_sqlalchemy import SQLAlchemy
import datetime

db = SQLAlchemy()

class Workflow(db.Model):
    id = db.Column(db.Integer, primary_key=True)
    name = db.Column(db.String(100), nullable=False)
    description = db.Column(db.Text)
    created_at = db.Column(db.DateTime, default=datetime.datetime.now)
    created_by = db.Column(db.Integer, db.ForeignKey('user.id'))

    def to_dict(self):
        return {
            'id': self.id,
            'name': self.name,
            'description': self.description,
            'created_at': self.created_at,
            'created_by': self.created_by
        }

class WorkflowStep(db.Model):
    id = db.Column(db.Integer, primary_key=True)
    workflow_id = db.Column(db.Integer, db.ForeignKey('workflow.id', ondelete='CASCADE'), nullable=False)
    step_order = db.Column(db.Integer, nullable=False)
    name = db.Column(db.String(100), nullable=False)
    description = db.Column(db.Text)
    approver_id = db.Column(db.Integer, db.ForeignKey('user.id'))

    def to_dict(self):
        return {
            'id': self.id,
            'workflow_id': self.workflow_id,
            'step_order': self.step_order,
            'name': self.name,
            'description': self.description,
            'approver_id': self.approver_id
        }

class DocumentApproval(db.Model):
    id = db.Column(db.Integer, primary_key=True)
    document_id = db.Column(db.Integer, db.ForeignKey('document.id', ondelete='CASCADE'), nullable=False)
    workflow_id = db.Column(db.Integer, db.ForeignKey('workflow.id'), nullable=False)
    current_step = db.Column(db.Integer, default=1, nullable=False)
    status = db.Column(db.Enum('pending', 'approved', 'rejected'), default='pending')
    started_at = db.Column(db.DateTime, default=datetime.datetime.now)
    completed_at = db.Column(db.DateTime)

    def to_dict(self):
        return {
            'id': self.id,
            'document_id': self.document_id,
            'workflow_id': self.workflow_id,
            'current_step': self.current_step,
            'status': self.status,
            'started_at': self.started_at,
            'completed_at': self.completed_at
        }

class ApprovalHistory(db.Model):
    id = db.Column(db.Integer, primary_key=True)
    document_approval_id = db.Column(db.Integer, db.ForeignKey('document_approval.id', ondelete='CASCADE'), nullable=False)
    step_id = db.Column(db.Integer, db.ForeignKey('workflow_step.id'), nullable=False)
    user_id = db.Column(db.Integer, db.ForeignKey('user.id'), nullable=False)
    action = db.Column(db.Enum('approved', 'rejected', 'commented'), nullable=False)
    comments = db.Column(db.Text)
    created_at = db.Column(db.DateTime, default=datetime.datetime.now)

    def to_dict(self):
        return {
            'id': self.id,
            'document_approval_id': self.document_approval_id,
            'step_id': self.step_id,
            'user_id': self.user_id,
            'action': self.action,
            'comments': self.comments,
            'created_at': self.created_at
        }
