<?php
/**
 * Página de Download de Documentos
 * Sistema de Gerenciamento Eletrônico de Documentos (GED)
 */

// Iniciar sessão e verificar autenticação
session_start();
if (!isset($_SESSION["user_id"])) {
    header("Location: login.php");
    exit;
}

// Incluir arquivos necessários
require_once "config/database.php";
require_once "models/document.php";
require_once "models/document_version.php";
require_once "models/audit_log.php";

// Verificar se o ID do documento foi fornecido
if (!isset($_GET["id"]) || empty($_GET["id"])) {
    $_SESSION["flash_message"] = "ID do documento não fornecido.";
    $_SESSION["flash_type"] = "danger";
    header("Location: documents.php");
    exit;
}

$document_id = $_GET["id"];
$version_number = $_GET["version"] ?? null; // Versão específica, se fornecida

// Conectar ao banco de dados
$database = new Database();
$db = $database->getConnection();

// Instanciar modelos
$document = new Document($db);
$document_version = new DocumentVersion($db);

$file_path = null;
$file_name = null;
$file_size = null;

if ($version_number) {
    // Tentar obter a versão específica
    $version_data = $document_version->getVersionByDocumentAndNumber($document_id, $version_number);
    if ($version_data) {
        $file_path = $version_data["file_path"];
        $file_name = basename($version_data["file_path"]);
        $file_size = $version_data["file_size"];
    }
} else {
    // Tentar obter o documento principal
    if ($document->readOne($document_id)) {
        $file_path = $document->file_path;
        $file_name = basename($document->file_path);
        $file_size = $document->file_size;
    }
}

if ($file_path && file_exists($file_path)) {
    // Registrar download nos logs
    logAudit($_SESSION["user_id"], "download", "document", $document_id, "Baixou o documento: " . ($file_name ?? $document->title));

    // Forçar download do arquivo
    header("Content-Description: File Transfer");
    header("Content-Type: application/octet-stream");
    header("Content-Disposition: attachment; filename=\"" . $file_name . "\"");
    header("Expires: 0");
    header("Cache-Control: must-revalidate");
    header("Pragma: public");
    header("Content-Length: " . $file_size);
    readfile($file_path);
    exit;
} else {
    $_SESSION["flash_message"] = "Arquivo não encontrado ou inacessível.";
    $_SESSION["flash_type"] = "danger";
    header("Location: document_view.php?id=" . $document_id);
    exit;
}

function logAudit($user_id, $action, $entity_type, $entity_id, $details) {
    global $db;
    $audit_log = new AuditLog($db);
    $audit_log->user_id = $user_id;
    $audit_log->action = $action;
    $audit_log->entity_type = $entity_type;
    $audit_log->entity_id = $entity_id;
    $audit_log->details = $details;
    $audit_log->ip_address = $_SERVER["REMOTE_ADDR"] ?? "0.0.0.0";
    $audit_log->user_agent = $_SERVER["HTTP_USER_AGENT"] ?? "Unknown";
    return $audit_log->create();
}

?>

