<?php
/**
 * Página para restaurar uma versão de documento
 * Sistema de Gerenciamento Eletrônico de Documentos (GED)
 */

// Iniciar sessão e verificar autenticação
session_start();
if (!isset($_SESSION["user_id"])) {
    header("Location: login.php");
    exit;
}

// Verificar se o ID do documento e o número da versão foram fornecidos
if (!isset($_GET["id"]) || empty($_GET["id"]) || !isset($_GET["version"]) || empty($_GET["version"])) {
    $_SESSION["flash_message"] = "ID do documento ou número da versão não fornecido.";
    $_SESSION["flash_type"] = "danger";
    header("Location: documents.php");
    exit;
}

$document_id = $_GET["id"];
$version_number = $_GET["version"];

// Incluir arquivos necessários
require_once "config/database.php";
require_once "models/document.php";
require_once "models/document_version.php";
require_once "models/audit_log.php";
require_once "controllers/document_controller.php";

// Conectar ao banco de dados
$database = new Database();
$db = $database->getConnection();

// Instanciar controladores e modelos
$document_controller = new DocumentController();
$document = new Document($db);
$document_version = new DocumentVersion($db);

// Obter detalhes do documento original
if (!$document->readOne($document_id)) {
    $_SESSION["flash_message"] = "Documento original não encontrado.";
    $_SESSION["flash_type"] = "danger";
    header("Location: documents.php");
    exit;
}

// Obter a versão a ser restaurada
$version_data = $document_version->getVersionByDocumentAndNumber($document_id, $version_number);

if (!$version_data) {
    $_SESSION["flash_message"] = "Versão do documento não encontrada.";
    $_SESSION["flash_type"] = "danger";
    header("Location: document_view.php?id=" . $document_id);
    exit;
}

// Verificar permissão para restaurar (apenas autor ou admin)
$user_id = $_SESSION["user_id"];
$user_type = $_SESSION["user_type"];

if ($document->created_by != $user_id && $user_type != "admin") {
    $_SESSION["flash_message"] = "Você não tem permissão para restaurar este documento.";
    $_SESSION["flash_type"] = "danger";
    header("Location: document_view.php?id=" . $document_id);
    exit;
}

// Tentar restaurar a versão
$result = $document_controller->restoreDocumentVersion($document_id, $version_number, $user_id);

if ($result["success"]) {
    $_SESSION["flash_message"] = "Versão do documento restaurada com sucesso!";
    $_SESSION["flash_type"] = "success";
} else {
    $_SESSION["flash_message"] = $result["message"];
    $_SESSION["flash_type"] = "danger";
}

header("Location: document_view.php?id=" . $document_id);
exit;

?>

