<?php
/**
 * Cabeçalho padrão do sistema
 * Sistema de Gerenciamento Eletrônico de Documentos (GED)
 */

// Iniciar sessão se ainda não estiver iniciada
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// Verificar se o usuário está logado
$is_logged_in = isset($_SESSION['user_id']);
$user_name = $is_logged_in ? $_SESSION['user_name'] : '';
$user_type = $is_logged_in ? $_SESSION['user_type'] : '';

// Verificar tema atual (padrão: claro)
$theme = isset($_COOKIE['theme']) ? $_COOKIE['theme'] : 'light';

// Função para verificar a página atual
function isCurrentPage($page) {
    $current_page = basename($_SERVER['PHP_SELF']);
    return $current_page == $page;
}
?>
<!DOCTYPE html>
<html lang="pt-BR" data-bs-theme="<?php echo $theme; ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sistema GED - <?php echo isset($page_title) ? $page_title : 'Gerenciamento Eletrônico de Documentos'; ?></title>
    
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    
    <!-- DataTables CSS -->
    <link href="https://cdn.datatables.net/1.11.5/css/dataTables.bootstrap5.min.css" rel="stylesheet">
    
    <!-- Select2 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/select2-bootstrap-5-theme@1.3.0/dist/select2-bootstrap-5-theme.min.css" rel="stylesheet">
    
    <!-- Custom CSS -->
    <link href="assets/css/style.css" rel="stylesheet">
</head>
<body>
    <!-- Navbar -->
    <nav class="navbar navbar-expand-lg navbar-dark bg-primary">
        <div class="container-fluid">
            <a class="navbar-brand" href="index.php">
                <i class="fas fa-file-archive me-2"></i>
                Sistema GED
            </a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarMain">
                <span class="navbar-toggler-icon"></span>
            </button>
            
            <div class="collapse navbar-collapse" id="navbarMain">
                <?php if ($is_logged_in): ?>
                <ul class="navbar-nav me-auto">
                    <li class="nav-item">
                        <a class="nav-link <?php echo isCurrentPage('index.php') ? 'active' : ''; ?>" href="index.php">
                            <i class="fas fa-tachometer-alt me-1"></i> Dashboard
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link <?php echo isCurrentPage('documents.php') ? 'active' : ''; ?>" href="documents.php">
                            <i class="fas fa-file-alt me-1"></i> Documentos
                        </a>
                    </li>
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown" role="button" data-bs-toggle="dropdown">
                            <i class="fas fa-cogs me-1"></i> Gerenciar
                        </a>
                        <ul class="dropdown-menu">
                            <li>
                                <a class="dropdown-item <?php echo isCurrentPage('categories.php') ? 'active' : ''; ?>" href="categories.php">
                                    <i class="fas fa-tags me-1"></i> Categorias
                                </a>
                            </li>
                            <li>
                                <a class="dropdown-item <?php echo isCurrentPage('workflows.php') ? 'active' : ''; ?>" href="workflows.php">
                                    <i class="fas fa-project-diagram me-1"></i> Workflows
                                </a>
                            </li>
                            <?php if ($user_type == 'admin'): ?>
                            <li><hr class="dropdown-divider"></li>
                            <li>
                                <a class="dropdown-item <?php echo isCurrentPage('users.php') ? 'active' : ''; ?>" href="users.php">
                                    <i class="fas fa-users me-1"></i> Usuários
                                </a>
                            </li>
                            <li>
                                <a class="dropdown-item <?php echo isCurrentPage('audit_logs.php') ? 'active' : ''; ?>" href="audit_logs.php">
                                    <i class="fas fa-history me-1"></i> Logs de Auditoria
                                </a>
                            </li>
                            <li>
                                <a class="dropdown-item <?php echo isCurrentPage('settings.php') ? 'active' : ''; ?>" href="settings.php">
                                    <i class="fas fa-cog me-1"></i> Configurações
                                </a>
                            </li>
                            <?php endif; ?>
                        </ul>
                    </li>
                </ul>
                
                <!-- Pesquisa rápida -->
                <form class="d-flex mx-auto" action="search.php" method="GET">
                    <div class="input-group">
                        <input class="form-control" type="search" name="q" placeholder="Pesquisar documentos..." aria-label="Pesquisar">
                        <button class="btn btn-light" type="submit">
                            <i class="fas fa-search"></i>
                        </button>
                    </div>
                </form>
                
                <!-- Menu do usuário -->
                <ul class="navbar-nav ms-auto">
                    <li class="nav-item">
                        <a class="nav-link" href="#" id="toggleTheme">
                            <i class="fas <?php echo $theme == 'dark' ? 'fa-sun' : 'fa-moon'; ?>"></i>
                        </a>
                    </li>
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" id="userDropdown" role="button" data-bs-toggle="dropdown">
                            <i class="fas fa-user-circle me-1"></i> <?php echo htmlspecialchars($user_name); ?>
                        </a>
                        <ul class="dropdown-menu dropdown-menu-end">
                            <li>
                                <a class="dropdown-item" href="profile.php">
                                    <i class="fas fa-id-card me-1"></i> Meu Perfil
                                </a>
                            </li>
                            <li>
                                <a class="dropdown-item" href="pending_approvals.php">
                                    <i class="fas fa-tasks me-1"></i> Aprovações Pendentes
                                </a>
                            </li>
                            <li><hr class="dropdown-divider"></li>
                            <li>
                                <a class="dropdown-item" href="logout.php">
                                    <i class="fas fa-sign-out-alt me-1"></i> Sair
                                </a>
                            </li>
                        </ul>
                    </li>
                </ul>
                <?php else: ?>
                <ul class="navbar-nav ms-auto">
                    <li class="nav-item">
                        <a class="nav-link" href="#" id="toggleTheme">
                            <i class="fas <?php echo $theme == 'dark' ? 'fa-sun' : 'fa-moon'; ?>"></i>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="login.php">
                            <i class="fas fa-sign-in-alt me-1"></i> Entrar
                        </a>
                    </li>
                </ul>
                <?php endif; ?>
            </div>
        </div>
    </nav>

    <!-- Conteúdo principal -->
    <div class="container-fluid py-4">
        <?php if (isset($_SESSION['flash_message'])): ?>
        <div class="alert alert-<?php echo $_SESSION['flash_type'] ?? 'info'; ?> alert-dismissible fade show">
            <?php echo $_SESSION['flash_message']; ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
        <?php 
        // Limpar mensagem flash após exibição
        unset($_SESSION['flash_message']);
        unset($_SESSION['flash_type']);
        endif; 
        ?>
