<?php
/**
 * Página de Logout
 * Sistema de Gerenciamento Eletrônico de Documentos (GED)
 */

// Iniciar sessão
session_start();

// Incluir arquivos necessários
require_once 'config/database.php';
require_once 'models/audit_log.php';

// Conectar ao banco de dados para registrar o log de auditoria
$database = new Database();
$db = $database->getConnection();

// Registrar logout nos logs de auditoria, se o usuário estiver logado
if (isset($_SESSION['user_id'])) {
    $audit_log = new AuditLog($db);
    $audit_log->user_id = $_SESSION['user_id'];
    $audit_log->action = 'logout';
    $audit_log->entity_type = 'user';
    $audit_log->entity_id = $_SESSION['user_id'];
    $audit_log->details = 'Usuário ' . $_SESSION['username'] . ' desconectou.';
    $audit_log->ip_address = $_SERVER['REMOTE_ADDR'] ?? '0.0.0.0';
    $audit_log->user_agent = $_SERVER['HTTP_USER_AGENT'] ?? 'Unknown';
    $audit_log->create();
}

// Destruir todas as variáveis de sessão
$_SESSION = array();

// Se for preciso matar completamente a sessão, apague também o cookie de sessão.
// Nota: Isso destruirá a sessão, e não apenas os dados da sessão!
if (ini_get("session.use_cookies")) {
    $params = session_get_cookie_params();
    setcookie(session_name(), '', time() - 42000,
        $params["path"], $params["domain"],
        $params["secure"], $params["httponly"]
    );
}

// Finalmente, destruir a sessão.
session_destroy();

// Redirecionar para a página de login
header("Location: login.php");
exit;
?>

