<?php
/**
 * Script de configuração para produção
 * Sistema de Gerenciamento Eletrônico de Documentos (GED)
 */

// Incluir configurações
require_once 'config/config.php';

echo "=== Configuração do Sistema GED para Produção ===\n\n";

try {
    // Conectar ao banco de dados
    $database = new Database();
    $db = $database->getConnection();
    
    echo "✓ Conexão com banco de dados estabelecida\n";
    
    // Verificar se o usuário admin existe
    $stmt = $db->prepare("SELECT id FROM user WHERE username = 'admin'");
    $stmt->execute();
    
    if ($stmt->rowCount() == 0) {
        echo "✗ Usuário admin não encontrado\n";
        exit(1);
    }
    
    echo "✓ Usuário admin encontrado\n";
    
    // Atualizar senha do admin
    $password_hash = '$2y$10$EIQo2geseDoOvXoApkCW2uZ2zGB6LjIhr/PTiGmjJVzIHJQ4/FeFy';
    $stmt = $db->prepare("UPDATE user SET password_hash = ? WHERE username = 'admin'");
    $stmt->execute([$password_hash]);
    
    echo "✓ Senha do admin atualizada (admin123)\n";
    
    // Verificar permissões
    $permissions = [
        'view_document' => 'Visualizar documentos',
        'upload_document' => 'Fazer upload de documentos',
        'edit_document' => 'Editar documentos',
        'delete_document' => 'Excluir documentos',
        'manage_users' => 'Gerenciar usuários',
        'manage_permissions' => 'Gerenciar permissões',
        'manage_categories' => 'Gerenciar categorias',
        'manage_workflows' => 'Gerenciar workflows',
        'view_audit_logs' => 'Visualizar logs de auditoria'
    ];
    
    foreach ($permissions as $name => $description) {
        $stmt = $db->prepare("INSERT IGNORE INTO permission (name, description) VALUES (?, ?)");
        $stmt->execute([$name, $description]);
    }
    
    echo "✓ Permissões verificadas e atualizadas\n";
    
    // Garantir que admin tenha todas as permissões
    $stmt = $db->prepare("INSERT IGNORE INTO user_permission (user_id, permission_id) SELECT 1, id FROM permission");
    $stmt->execute();
    
    echo "✓ Permissões do admin atualizadas\n";
    
    // Verificar diretórios necessários
    $directories = ['uploads', 'logs'];
    
    foreach ($directories as $dir) {
        if (!file_exists($dir)) {
            mkdir($dir, 0755, true);
            echo "✓ Diretório '$dir' criado\n";
        } else {
            echo "✓ Diretório '$dir' já existe\n";
        }
    }
    
    // Verificar permissões de diretórios
    chmod('uploads', 0755);
    chmod('logs', 0755);
    
    echo "✓ Permissões de diretórios configuradas\n";
    
    // Estatísticas do sistema
    $stats = [];
    
    $stmt = $db->query("SELECT COUNT(*) as count FROM user");
    $stats['users'] = $stmt->fetch()['count'];
    
    $stmt = $db->query("SELECT COUNT(*) as count FROM category");
    $stats['categories'] = $stmt->fetch()['count'];
    
    $stmt = $db->query("SELECT COUNT(*) as count FROM document");
    $stats['documents'] = $stmt->fetch()['count'];
    
    $stmt = $db->query("SELECT COUNT(*) as count FROM permission");
    $stats['permissions'] = $stmt->fetch()['count'];
    
    echo "\n=== Estatísticas do Sistema ===\n";
    echo "Usuários: {$stats['users']}\n";
    echo "Categorias: {$stats['categories']}\n";
    echo "Documentos: {$stats['documents']}\n";
    echo "Permissões: {$stats['permissions']}\n";
    
    echo "\n✓ Sistema configurado com sucesso para produção!\n";
    echo "\nCredenciais de acesso:\n";
    echo "Usuário: admin\n";
    echo "Senha: admin123\n";
    
} catch (Exception $e) {
    echo "✗ Erro durante a configuração: " . $e->getMessage() . "\n";
    exit(1);
}
?>

