# Instruções de Instalação - Sistema GED

Este documento contém instruções detalhadas para instalar o Sistema de Gerenciamento Eletrônico de Documentos (GED) em seu servidor.

## Requisitos do Sistema

- PHP 7.4 ou superior
- MySQL 5.7 ou superior
- Servidor web (Apache, Nginx)
- Extensões PHP: PDO, MySQLi, GD, Zip, mbstring

## Passo a Passo para Instalação

### 1. Preparação do Ambiente

1. Verifique se seu servidor atende aos requisitos mínimos:
   ```bash
   php -v
   mysql --version
   ```

2. Certifique-se de que as extensões PHP necessárias estão habilitadas:
   - Abra o arquivo `php.ini` do seu servidor
   - Verifique se as seguintes extensões estão descomentadas (sem `;` no início da linha):
     ```
     extension=pdo
     extension=mysqli
     extension=gd
     extension=zip
     extension=mbstring
     ```

### 2. Configuração do Banco de Dados

1. Acesse o phpMyAdmin ou outro gerenciador de banco de dados MySQL
2. Crie um novo banco de dados para o sistema:
   ```sql
   CREATE DATABASE ged_db1;
   ```
3. Crie um usuário com privilégios para este banco de dados:
   ```sql
   CREATE USER 'ged_user'@'localhost' IDENTIFIED BY 'sua_senha_segura';
   GRANT ALL PRIVILEGES ON ged_db1.* TO 'ged_user'@'localhost';
   FLUSH PRIVILEGES;
   ```
4. Importe o arquivo `database/setup.sql` para criar as tabelas necessárias:
   - No phpMyAdmin, selecione o banco de dados criado
   - Clique na aba "Importar"
   - Selecione o arquivo `setup.sql` e clique em "Executar"

### 3. Upload dos Arquivos

1. Descompacte o arquivo ZIP do sistema
2. Faça upload de todos os arquivos para o diretório desejado no seu servidor:
   - Via FTP: use um cliente FTP como FileZilla para transferir os arquivos
   - Via cPanel: use o Gerenciador de Arquivos para fazer upload dos arquivos
   - Via SSH: use comandos como `scp` ou `rsync` para transferir os arquivos

### 4. Configuração do Sistema

1. Renomeie o arquivo `.env.example` para `.env`:
   ```bash
   mv .env.example .env
   ```

2. Edite o arquivo `.env` com as configurações do seu ambiente:
   ```
   # Configurações do Banco de Dados
   DB_HOST=localhost
   DB_NAME=ged_db1
   DB_USER=ged_user
   DB_PASS=sua_senha_segura
   
   # Configurações do Sistema
   SITE_URL=https://sysged.com.br
   UPLOAD_DIR=uploads
   MAX_UPLOAD_SIZE=10
   
   # Configurações de Segurança
   SECRET_KEY=gere_uma_chave_aleatoria_aqui
   ```

3. Configure as permissões de diretório:
   ```bash
   chmod 755 -R .
   chmod 777 -R uploads
   chmod 777 -R tmp
   ```

### 5. Configuração do Servidor Web

#### Para Apache:

1. Certifique-se de que o mod_rewrite está habilitado:
   ```bash
   a2enmod rewrite
   ```

2. Renomeie o arquivo `.htaccess.example` para `.htaccess`:
   ```bash
   mv .htaccess.example .htaccess
   ```

3. Edite o arquivo de configuração do virtual host:
   ```apache
   <VirtualHost *:80>
       ServerName sysged.com.br
       DocumentRoot /caminho/para/ged_php
       
       <Directory /caminho/para/ged_php>
           Options -Indexes +FollowSymLinks
           AllowOverride All
           Require all granted
       </Directory>
       
       ErrorLog ${APACHE_LOG_DIR}/ged_error.log
       CustomLog ${APACHE_LOG_DIR}/ged_access.log combined
   </VirtualHost>
   ```

4. Reinicie o Apache:
   ```bash
   sudo service apache2 restart
   ```

#### Para Nginx:

1. Crie um arquivo de configuração para o site:
   ```nginx
   server {
       listen 80;
       server_name sysged.com.br;
       root /caminho/para/ged_php;
       index index.php;
       
       location / {
           try_files $uri $uri/ /index.php?$query_string;
       }
       
       location ~ \.php$ {
           include snippets/fastcgi-php.conf;
           fastcgi_pass unix:/var/run/php/php7.4-fpm.sock;
       }
       
       location ~ /\.ht {
           deny all;
       }
   }
   ```

2. Reinicie o Nginx:
   ```bash
   sudo service nginx restart
   ```

### 6. Primeiro Acesso

1. Acesse o sistema usando o navegador: `https://sysged.com.br`
2. Faça login com as credenciais padrão:
   - Usuário: `admin`
   - Senha: `admin123`
3. **IMPORTANTE**: Altere a senha imediatamente após o primeiro login

## Verificação da Instalação

Para verificar se a instalação foi bem-sucedida, acesse:
```
https://sysged.com.br/test_integration.php
```

Este script executará testes de integração para verificar se todos os componentes do sistema estão funcionando corretamente.

## Solução de Problemas Comuns

### Erro de Conexão com o Banco de Dados

- Verifique se as credenciais no arquivo `.env` estão corretas
- Confirme se o usuário do banco de dados tem as permissões necessárias
- Verifique se o serviço MySQL está em execução

### Erro 500 Internal Server Error

- Verifique os logs de erro do servidor web
- Confirme se as permissões de arquivo estão corretas
- Verifique se o PHP está configurado corretamente

### Problemas de Upload de Arquivos

- Verifique se o diretório `uploads` tem permissões de escrita
- Confirme se o tamanho máximo de upload no PHP está configurado corretamente
- Verifique as configurações `post_max_size` e `upload_max_filesize` no php.ini

### Páginas em Branco

- Ative a exibição de erros no PHP para desenvolvimento:
  ```php
  ini_set('display_errors', 1);
  error_reporting(E_ALL);
  ```
- Verifique os logs de erro do PHP

## Suporte

Para suporte técnico ou dúvidas sobre a instalação, entre em contato através do e-mail suporte@sysged.com.br
