<?php
/**
 * Configuração de Banco de Dados - cPanel
 * Sistema GED - Gerenciamento Eletrônico de Documentos
 * 
 * CONFIGURAÇÕES PERSONALIZADAS PARA CPANEL
 * Banco: tremedal_ged_db1
 * Usuário: tremedal_ged
 * Senha: G7d875@#
 */

class Database {
    // Configurações do banco de dados para cPanel
    private $host = "localhost";
    private $db_name = "tremedal_ged_db1";
    private $username = "tremedal_ged";
    private $password = "G7d875@#";
    private $charset = "utf8mb4";
    
    public $conn;

    /**
     * Conectar ao banco de dados
     */
    public function getConnection() {
        $this->conn = null;

        try {
            $dsn = "mysql:host=" . $this->host . ";dbname=" . $this->db_name . ";charset=" . $this->charset;
            
            $options = [
                PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
                PDO::ATTR_EMULATE_PREPARES => false,
                PDO::MYSQL_ATTR_INIT_COMMAND => "SET NAMES utf8mb4"
            ];
            
            $this->conn = new PDO($dsn, $this->username, $this->password, $options);
            
        } catch(PDOException $exception) {
            error_log("Erro de conexão: " . $exception->getMessage());
            die("Erro de conexão com o banco de dados. Verifique as configurações.");
        }

        return $this->conn;
    }
    
    /**
     * Testar conexão com o banco
     */
    public function testConnection() {
        try {
            $conn = $this->getConnection();
            if ($conn) {
                return [
                    'success' => true,
                    'message' => 'Conexão estabelecida com sucesso!',
                    'database' => $this->db_name,
                    'host' => $this->host
                ];
            }
        } catch (Exception $e) {
            return [
                'success' => false,
                'message' => 'Erro na conexão: ' . $e->getMessage(),
                'database' => $this->db_name,
                'host' => $this->host
            ];
        }
    }
    
    /**
     * Obter informações da conexão
     */
    public function getConnectionInfo() {
        return [
            'host' => $this->host,
            'database' => $this->db_name,
            'username' => $this->username,
            'charset' => $this->charset
        ];
    }
}

// Função global para obter conexão
function getDBConnection() {
    $database = new Database();
    return $database->getConnection();
}

// Função para testar conexão
function testDBConnection() {
    $database = new Database();
    return $database->testConnection();
}
?>

