<?php
/**
 * Configuração de ambiente
 * Sistema de Gerenciamento Eletrônico de Documentos (GED)
 */

// Detectar ambiente
$is_production = getenv('ENVIRONMENT') === 'production' || 
                 isset($_SERVER['HTTP_HOST']) && 
                 !in_array($_SERVER['HTTP_HOST'], ['localhost', '127.0.0.1']);

// Configurações baseadas no ambiente
if ($is_production) {
    // Configurações de produção
    error_reporting(0);
    ini_set('display_errors', 0);
    ini_set('log_errors', 1);
    
    // Usar configuração de banco de produção
    require_once __DIR__ . '/database_production.php';
} else {
    // Configurações de desenvolvimento
    error_reporting(E_ALL);
    ini_set('display_errors', 1);
    
    // Usar configuração de banco de desenvolvimento
    require_once __DIR__ . '/database.php';
}

// Configurações globais
define('UPLOAD_PATH', __DIR__ . '/../uploads/');
define('MAX_FILE_SIZE', 10 * 1024 * 1024); // 10MB
define('ALLOWED_EXTENSIONS', ['pdf', 'doc', 'docx', 'jpg', 'jpeg', 'png', 'txt', 'csv']);

// Configurações de sessão
ini_set('session.cookie_httponly', 1);
ini_set('session.use_strict_mode', 1);

if ($is_production) {
    ini_set('session.cookie_secure', 1);
}

// Timezone
date_default_timezone_set('America/Sao_Paulo');
?>

