<?php
/**
 * Script para exclusão de arquivos de backup
 * Sistema de Gerenciamento Eletrônico de Documentos (GED)
 */

// Iniciar sessão e verificar autenticação
session_start();
if (!isset($_SESSION["user_id"])) {
    header("Location: login.php");
    exit;
}

// Verificar se o usuário tem permissão de administrador
if ($_SESSION["user_type"] != "admin") {
    $_SESSION["flash_message"] = "Acesso negado. Você não tem permissão para acessar esta funcionalidade.";
    $_SESSION["flash_type"] = "danger";
    header("Location: index.php");
    exit;
}

// Incluir arquivos necessários
require_once "config/database.php";
require_once "config/config.php";
require_once "controllers/backup_controller.php";

// Conectar ao banco de dados
$database = new Database();
$db = $database->getConnection();

// Instanciar controlador
$backup_controller = new BackupController();

if (isset($_GET["file"])) {
    $filename = $_GET["file"];
    $result = $backup_controller->deleteBackup($filename);
    
    $_SESSION["flash_message"] = $result["message"];
    $_SESSION["flash_type"] = $result["success"] ? "success" : "danger";

} else {
    $_SESSION["flash_message"] = "Nome do arquivo de backup não especificado.";
    $_SESSION["flash_type"] = "danger";
}

header("Location: backup.php");
exit;
?>

