<?php
/**
 * Página de Pré-visualização de Documentos
 * Sistema de Gerenciamento Eletrônico de Documentos (GED)
 */

// Iniciar sessão e verificar autenticação
session_start();
if (!isset($_SESSION["user_id"])) {
    // Redirecionar para login ou exibir mensagem de erro, dependendo da necessidade
    // Para pré-visualização, talvez seja melhor apenas não exibir o conteúdo
    exit("Acesso negado. Faça login para visualizar o documento.");
}

// Incluir arquivos necessários
require_once "config/database.php";
require_once "models/document.php";
require_once "models/document_version.php";

// Verificar se o ID do documento foi fornecido
if (!isset($_GET["id"]) || empty($_GET["id"])) {
    exit("ID do documento não fornecido.");
}

$document_id = $_GET["id"];
$version_number = $_GET["version"] ?? null; // Versão específica, se fornecida

// Conectar ao banco de dados
$database = new Database();
$db = $database->getConnection();

// Instanciar modelos
$document = new Document($db);
$document_version = new DocumentVersion($db);

$file_path = null;
$file_type = null;

if ($version_number) {
    // Tentar obter a versão específica
    $version_data = $document_version->getVersionByDocumentAndNumber($document_id, $version_number);
    if ($version_data) {
        $file_path = $version_data["file_path"];
        $file_type = $version_data["file_type"];
    }
} else {
    // Tentar obter o documento principal
    if ($document->readOne($document_id)) {
        $file_path = $document->file_path;
        $file_type = $document->file_type;
    }
}

if ($file_path && file_exists($file_path)) {
    // Definir cabeçalhos para exibir o arquivo no navegador
    header("Content-Type: " . $file_type);
    header("Content-Length: " . filesize($file_path));
    readfile($file_path);
    exit;
} else {
    exit("Arquivo não encontrado ou inacessível para pré-visualização.");
}

?>

