<?php
/**
 * Script de Instalação - Sistema GED para cPanel
 * 
 * Este script automatiza a instalação do Sistema GED em servidores cPanel
 * Configurações: tremedal_ged_db1 / tremedal_ged / G7d875@#
 */

// Configurações
$config = [
    'db_host' => 'localhost',
    'db_name' => 'tremedal_ged_db1',
    'db_user' => 'tremedal_ged',
    'db_pass' => 'G7d875@#',
    'admin_user' => 'admin',
    'admin_pass' => 'admin123'
];

echo "<!DOCTYPE html>
<html lang='pt-BR'>
<head>
    <meta charset='UTF-8'>
    <meta name='viewport' content='width=device-width, initial-scale=1.0'>
    <title>Instalação Sistema GED - cPanel</title>
    <style>
        body { font-family: Arial, sans-serif; max-width: 800px; margin: 0 auto; padding: 20px; background: #f5f5f5; }
        .container { background: white; padding: 30px; border-radius: 10px; box-shadow: 0 2px 10px rgba(0,0,0,0.1); }
        .header { text-align: center; color: #333; margin-bottom: 30px; }
        .step { background: #f8f9fa; padding: 15px; margin: 10px 0; border-left: 4px solid #007bff; }
        .success { border-left-color: #28a745; background: #d4edda; }
        .error { border-left-color: #dc3545; background: #f8d7da; }
        .warning { border-left-color: #ffc107; background: #fff3cd; }
        .code { background: #f1f1f1; padding: 10px; border-radius: 5px; font-family: monospace; margin: 10px 0; }
        .btn { background: #007bff; color: white; padding: 10px 20px; border: none; border-radius: 5px; cursor: pointer; }
        .btn:hover { background: #0056b3; }
    </style>
</head>
<body>
    <div class='container'>
        <div class='header'>
            <h1>📁 Sistema GED - Instalação cPanel</h1>
            <p>Instalação automatizada para servidor cPanel</p>
        </div>";

// Função para testar conexão
function testConnection($config) {
    try {
        $dsn = "mysql:host={$config['db_host']};dbname={$config['db_name']};charset=utf8mb4";
        $pdo = new PDO($dsn, $config['db_user'], $config['db_pass']);
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        return ['success' => true, 'message' => 'Conexão estabelecida com sucesso!'];
    } catch (PDOException $e) {
        return ['success' => false, 'message' => 'Erro: ' . $e->getMessage()];
    }
}

// Função para executar SQL
function executeSQL($config, $sql) {
    try {
        $dsn = "mysql:host={$config['db_host']};dbname={$config['db_name']};charset=utf8mb4";
        $pdo = new PDO($dsn, $config['db_user'], $config['db_pass']);
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        $pdo->exec($sql);
        return ['success' => true, 'message' => 'SQL executado com sucesso!'];
    } catch (PDOException $e) {
        return ['success' => false, 'message' => 'Erro SQL: ' . $e->getMessage()];
    }
}

// Passo 1: Testar conexão
echo "<div class='step'><h3>Passo 1: Testando Conexão com Banco de Dados</h3>";
$connectionTest = testConnection($config);
if ($connectionTest['success']) {
    echo "<div class='success'>✅ " . $connectionTest['message'] . "</div>";
    echo "<div class='code'>
        Host: {$config['db_host']}<br>
        Database: {$config['db_name']}<br>
        Usuário: {$config['db_user']}
    </div>";
} else {
    echo "<div class='error'>❌ " . $connectionTest['message'] . "</div>";
    echo "<div class='warning'>
        <strong>Ação Necessária:</strong><br>
        1. Verifique se o banco de dados '{$config['db_name']}' foi criado no cPanel<br>
        2. Verifique se o usuário '{$config['db_user']}' tem permissões no banco<br>
        3. Confirme se a senha está correta
    </div>";
}
echo "</div>";

// Passo 2: Verificar estrutura do banco
if ($connectionTest['success']) {
    echo "<div class='step'><h3>Passo 2: Verificando Estrutura do Banco</h3>";
    
    try {
        $dsn = "mysql:host={$config['db_host']};dbname={$config['db_name']};charset=utf8mb4";
        $pdo = new PDO($dsn, $config['db_user'], $config['db_pass']);
        
        // Verificar se tabelas existem
        $tables = ['user', 'document', 'category', 'workflow', 'audit_log', 'permission'];
        $existingTables = [];
        
        foreach ($tables as $table) {
            $stmt = $pdo->prepare("SHOW TABLES LIKE ?");
            $stmt->execute([$table]);
            if ($stmt->rowCount() > 0) {
                $existingTables[] = $table;
            }
        }
        
        if (count($existingTables) == count($tables)) {
            echo "<div class='success'>✅ Todas as tabelas necessárias estão presentes</div>";
        } else {
            echo "<div class='warning'>⚠️ Algumas tabelas estão faltando</div>";
            echo "<div class='code'>
                Tabelas encontradas: " . implode(', ', $existingTables) . "<br>
                Tabelas necessárias: " . implode(', ', $tables) . "
            </div>";
        }
        
    } catch (Exception $e) {
        echo "<div class='error'>❌ Erro ao verificar tabelas: " . $e->getMessage() . "</div>";
    }
    echo "</div>";
}

// Passo 3: Verificar usuário admin
if ($connectionTest['success']) {
    echo "<div class='step'><h3>Passo 3: Verificando Usuário Administrador</h3>";
    
    try {
        $dsn = "mysql:host={$config['db_host']};dbname={$config['db_name']};charset=utf8mb4";
        $pdo = new PDO($dsn, $config['db_user'], $config['db_pass']);
        
        $stmt = $pdo->prepare("SELECT * FROM user WHERE username = ?");
        $stmt->execute(['admin']);
        $admin = $stmt->fetch();
        
        if ($admin) {
            echo "<div class='success'>✅ Usuário admin encontrado</div>";
            echo "<div class='code'>
                ID: {$admin['id']}<br>
                Username: {$admin['username']}<br>
                Email: {$admin['email']}<br>
                Status: " . ($admin['is_active'] ? 'Ativo' : 'Inativo') . "
            </div>";
        } else {
            echo "<div class='warning'>⚠️ Usuário admin não encontrado</div>";
            echo "<div class='code'>Será necessário criar o usuário admin</div>";
        }
        
    } catch (Exception $e) {
        echo "<div class='error'>❌ Erro ao verificar usuário: " . $e->getMessage() . "</div>";
    }
    echo "</div>";
}

// Passo 4: Verificar permissões de arquivo
echo "<div class='step'><h3>Passo 4: Verificando Permissões de Arquivos</h3>";

$directories = ['uploads', 'logs', 'config'];
$permissions = [];

foreach ($directories as $dir) {
    if (is_dir($dir)) {
        $perms = fileperms($dir);
        $permissions[$dir] = [
            'exists' => true,
            'writable' => is_writable($dir),
            'permissions' => substr(sprintf('%o', $perms), -4)
        ];
    } else {
        $permissions[$dir] = ['exists' => false, 'writable' => false, 'permissions' => 'N/A'];
    }
}

foreach ($permissions as $dir => $info) {
    if ($info['exists'] && $info['writable']) {
        echo "<div class='success'>✅ Diretório '$dir' - OK (Permissões: {$info['permissions']})</div>";
    } else {
        echo "<div class='warning'>⚠️ Diretório '$dir' - Problema detectado</div>";
        if (!$info['exists']) {
            echo "<div class='code'>Diretório não existe - será criado automaticamente</div>";
        } elseif (!$info['writable']) {
            echo "<div class='code'>Sem permissão de escrita - ajuste necessário</div>";
        }
    }
}
echo "</div>";

// Passo 5: Resumo da instalação
echo "<div class='step'><h3>Passo 5: Resumo da Instalação</h3>";

if ($connectionTest['success']) {
    echo "<div class='success'>
        <h4>✅ Sistema Pronto para Uso!</h4>
        <p><strong>URL de Acesso:</strong> <a href='login.php'>login.php</a></p>
        <p><strong>Credenciais:</strong></p>
        <div class='code'>
            Usuário: admin<br>
            Senha: admin123
        </div>
        <p><strong>Configurações do Banco:</strong></p>
        <div class='code'>
            Host: {$config['db_host']}<br>
            Database: {$config['db_name']}<br>
            Usuário: {$config['db_user']}
        </div>
    </div>";
} else {
    echo "<div class='error'>
        <h4>❌ Instalação Incompleta</h4>
        <p>Corrija os problemas identificados acima antes de prosseguir.</p>
    </div>";
}

echo "</div>";

echo "
        <div class='step'>
            <h3>Próximos Passos:</h3>
            <ol>
                <li>Se tudo estiver OK, acesse <a href='login.php'>login.php</a></li>
                <li>Faça login com admin/admin123</li>
                <li>Altere a senha do administrador</li>
                <li>Configure as categorias iniciais</li>
                <li>Teste o upload de documentos</li>
            </ol>
        </div>
        
        <div class='step'>
            <p><strong>Suporte:</strong> Em caso de problemas, consulte o manual de instalação ou verifique os logs de erro do servidor.</p>
        </div>
    </div>
</body>
</html>";
?>

