<?php
class WorkflowApproval {
    private $conn;
    private $table_name = "workflow_approvals";

    public $id;
    public $document_id;
    public $workflow_step_id;
    public $approver_id;
    public $status;
    public $comments;
    public $approved_at;

    public function __construct($db) {
        $this->conn = $db;
    }

    public function create() {
        $query = "INSERT INTO " . $this->table_name . "
                SET
                    document_id=:document_id,
                    workflow_step_id=:workflow_step_id,
                    approver_id=:approver_id,
                    status=:status,
                    comments=:comments";

        $stmt = $this->conn->prepare($query);

        $this->document_id = htmlspecialchars(strip_tags($this->document_id));
        $this->workflow_step_id = htmlspecialchars(strip_tags($this->workflow_step_id));
        $this->approver_id = htmlspecialchars(strip_tags($this->approver_id));
        $this->status = htmlspecialchars(strip_tags($this->status));
        $this->comments = htmlspecialchars(strip_tags($this->comments));

        $stmt->bindParam(":document_id", $this->document_id);
        $stmt->bindParam(":workflow_step_id", $this->workflow_step_id);
        $stmt->bindParam(":approver_id", $this->approver_id);
        $stmt->bindParam(":status", $this->status);
        $stmt->bindParam(":comments", $this->comments);

        if ($stmt->execute()) {
            return true;
        }
        return false;
    }

    public function readByDocumentAndStep() {
        $query = "SELECT
                    wa.id, wa.document_id, wa.workflow_step_id, wa.approver_id, wa.status, wa.comments, wa.approved_at,
                    u.full_name as approver_name
                FROM
                    " . $this->table_name . " wa
                    LEFT JOIN
                        user u ON wa.approver_id = u.id
                WHERE
                    wa.document_id = ? AND wa.workflow_step_id = ?
                LIMIT 0,1";

        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(1, $this->document_id);
        $stmt->bindParam(2, $this->workflow_step_id);
        $stmt->execute();

        $row = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($row) {
            $this->id = $row["id"];
            $this->document_id = $row["document_id"];
            $this->workflow_step_id = $row["workflow_step_id"];
            $this->approver_id = $row["approver_id"];
            $this->status = $row["status"];
            $this->comments = $row["comments"];
            $this->approved_at = $row["approved_at"];
            return true;
        }
        return false;
    }

    public function update() {
        $query = "UPDATE " . $this->table_name . "
                SET
                    status=:status,
                    comments=:comments,
                    approved_at=NOW()
                WHERE
                    id=:id";

        $stmt = $this->conn->prepare($query);

        $this->status = htmlspecialchars(strip_tags($this->status));
        $this->comments = htmlspecialchars(strip_tags($this->comments));
        $this->id = htmlspecialchars(strip_tags($this->id));

        $stmt->bindParam(":status", $this->status);
        $stmt->bindParam(":comments", $this->comments);
        $stmt->bindParam(":id", $this->id);

        if ($stmt->execute()) {
            return true;
        }
        return false;
    }

    public function deleteByDocumentId() {
        $query = "DELETE FROM " . $this->table_name . " WHERE document_id = ?";
        $stmt = $this->conn->prepare($query);
        $this->document_id = htmlspecialchars(strip_tags($this->document_id));
        $stmt->bindParam(1, $this->document_id);

        if ($stmt->execute()) {
            return true;
        }
        return false;
    }

    public function deleteByWorkflowStepId() {
        $query = "DELETE FROM " . $this->table_name . " WHERE workflow_step_id = ?";
        $stmt = $this->conn->prepare($query);
        $this->workflow_step_id = htmlspecialchars(strip_tags($this->workflow_step_id));
        $stmt->bindParam(1, $this->workflow_step_id);

        if ($stmt->execute()) {
            return true;
        }
        return false;
    }

    public function readAllByDocumentId() {
        $query = "SELECT
                    wa.id, wa.document_id, wa.workflow_step_id, wa.approver_id, wa.status, wa.comments, wa.approved_at,
                    u.full_name as approver_name, ws.name as step_name, ws.step_order
                FROM
                    " . $this->table_name . " wa
                    LEFT JOIN user u ON wa.approver_id = u.id
                    LEFT JOIN workflow_steps ws ON wa.workflow_step_id = ws.id
                WHERE
                    wa.document_id = ?
                ORDER BY
                    ws.step_order ASC";

        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(1, $this->document_id);
        $stmt->execute();

        return $stmt;
    }
}
?>

