<?php
class WorkflowStep {
    private $conn;
    private $table_name = "workflow_step";

    public $id;
    public $workflow_id;
    public $step_order;
    public $name;
    public $description;
    public $assigned_to_user_type;
    public $assigned_to_user_id;

    public function __construct($db) {
        $this->conn = $db;
    }

    public function create() {
        $query = "INSERT INTO " . $this->table_name . "
                SET
                    workflow_id=:workflow_id,
                    step_order=:step_order,
                    name=:name,
                    description=:description,
                    assigned_to_user_type=:assigned_to_user_type,
                    assigned_to_user_id=:assigned_to_user_id";

        $stmt = $this->conn->prepare($query);

        $this->workflow_id = htmlspecialchars(strip_tags($this->workflow_id));
        $this->step_order = htmlspecialchars(strip_tags($this->step_order));
        $this->name = htmlspecialchars(strip_tags($this->name));
        $this->description = htmlspecialchars(strip_tags($this->description));
        $this->assigned_to_user_type = htmlspecialchars(strip_tags($this->assigned_to_user_type));
        $this->assigned_to_user_id = htmlspecialchars(strip_tags($this->assigned_to_user_id));

        $stmt->bindParam(":workflow_id", $this->workflow_id);
        $stmt->bindParam(":step_order", $this->step_order);
        $stmt->bindParam(":name", $this->name);
        $stmt->bindParam(":description", $this->description);
        $stmt->bindParam(":assigned_to_user_type", $this->assigned_to_user_type);
        $stmt->bindParam(":assigned_to_user_id", $this->assigned_to_user_id);

        if ($stmt->execute()) {
            return true;
        }
        return false;
    }

    public function readByWorkflowId() {
        $query = "SELECT
                    ws.id, ws.workflow_id, ws.step_order, ws.name, ws.description, ws.assigned_to_user_type, ws.assigned_to_user_id,
                    u.full_name as assigned_to_user_name
                FROM
                    " . $this->table_name . " ws
                    LEFT JOIN
                        user u ON ws.assigned_to_user_id = u.id
                WHERE
                    ws.workflow_id = ?
                ORDER BY
                    ws.step_order ASC";

        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(1, $this->workflow_id);
        $stmt->execute();

        return $stmt;
    }

    public function readOne() {
        $query = "SELECT
                    ws.id, ws.workflow_id, ws.step_order, ws.name, ws.description, ws.assigned_to_user_type, ws.assigned_to_user_id,
                    u.full_name as assigned_to_user_name
                FROM
                    " . $this->table_name . " ws
                    LEFT JOIN
                        user u ON ws.assigned_to_user_id = u.id
                WHERE
                    ws.id = ?
                LIMIT
                    0,1";

        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(1, $this->id);
        $stmt->execute();

        $row = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($row) {
            $this->workflow_id = $row["workflow_id"];
            $this->step_order = $row["step_order"];
            $this->name = $row["name"];
            $this->description = $row["description"];
            $this->assigned_to_user_type = $row["assigned_to_user_type"];
            $this->assigned_to_user_id = $row["assigned_to_user_id"];
            return true;
        }
        return false;
    }

    public function update() {
        $query = "UPDATE " . $this->table_name . "
                SET
                    step_order=:step_order,
                    name=:name,
                    description=:description,
                    assigned_to_user_type=:assigned_to_user_type,
                    assigned_to_user_id=:assigned_to_user_id
                WHERE
                    id=:id";

        $stmt = $this->conn->prepare($query);

        $this->step_order = htmlspecialchars(strip_tags($this->step_order));
        $this->name = htmlspecialchars(strip_tags($this->name));
        $this->description = htmlspecialchars(strip_tags($this->description));
        $this->assigned_to_user_type = htmlspecialchars(strip_tags($this->assigned_to_user_type));
        $this->assigned_to_user_id = htmlspecialchars(strip_tags($this->assigned_to_user_id));
        $this->id = htmlspecialchars(strip_tags($this->id));

        $stmt->bindParam(":step_order", $this->step_order);
        $stmt->bindParam(":name", $this->name);
        $stmt->bindParam(":description", $this->description);
        $stmt->bindParam(":assigned_to_user_type", $this->assigned_to_user_type);
        $stmt->bindParam(":assigned_to_user_id", $this->assigned_to_user_id);
        $stmt->bindParam(":id", $this->id);

        if ($stmt->execute()) {
            return true;
        }
        return false;
    }

    public function delete() {
        $query = "DELETE FROM " . $this->table_name . " WHERE id = ?";
        $stmt = $this->conn->prepare($query);
        $this->id = htmlspecialchars(strip_tags($this->id));
        $stmt->bindParam(1, $this->id);

        if ($stmt->execute()) {
            return true;
        }
        return false;
    }

    public function deleteByWorkflowId() {
        $query = "DELETE FROM " . $this->table_name . " WHERE workflow_id = ?";
        $stmt = $this->conn->prepare($query);
        $this->workflow_id = htmlspecialchars(strip_tags($this->workflow_id));
        $stmt->bindParam(1, $this->workflow_id);

        if ($stmt->execute()) {
            return true;
        }
        return false;
    }

    public function getLatestStepOrder($workflow_id) {
        $query = "SELECT MAX(step_order) as max_order FROM " . $this->table_name . " WHERE workflow_id = ?";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(1, $workflow_id);
        $stmt->execute();
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
        return $row["max_order"] ? $row["max_order"] : 0;
    }

    public function reorderStepsAfterDelete($workflow_id, $removed_order) {
        $query = "UPDATE " . $this->table_name . " SET step_order = step_order - 1 WHERE workflow_id = ? AND step_order > ?";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(1, $workflow_id);
        $stmt->bindParam(2, $removed_order);
        $stmt->execute();
    }

    public function updateOrder() {
        $query = "UPDATE " . $this->table_name . " SET step_order = :step_order WHERE id = :id";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(":step_order", $this->step_order);
        $stmt->bindParam(":id", $this->id);
        return $stmt->execute();
    }
}
?>

