<?php
/**
 * Script de Verificação Pós-Instalação
 * Sistema GED - cPanel Edition
 * 
 * Este script verifica se a instalação foi realizada corretamente
 */

// Configurações
$config = [
    'db_host' => 'localhost',
    'db_name' => 'tremedal_ged_db1',
    'db_user' => 'tremedal_ged',
    'db_pass' => 'G7d875@#'
];

?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Verificação da Instalação - Sistema GED</title>
    <style>
        body { font-family: Arial, sans-serif; max-width: 1000px; margin: 0 auto; padding: 20px; background: #f5f5f5; }
        .container { background: white; padding: 30px; border-radius: 10px; box-shadow: 0 2px 10px rgba(0,0,0,0.1); }
        .header { text-align: center; color: #333; margin-bottom: 30px; }
        .check-item { background: #f8f9fa; padding: 15px; margin: 10px 0; border-left: 4px solid #6c757d; border-radius: 5px; }
        .success { border-left-color: #28a745; background: #d4edda; }
        .error { border-left-color: #dc3545; background: #f8d7da; }
        .warning { border-left-color: #ffc107; background: #fff3cd; }
        .info { border-left-color: #17a2b8; background: #d1ecf1; }
        .code { background: #f1f1f1; padding: 10px; border-radius: 5px; font-family: monospace; margin: 10px 0; font-size: 12px; }
        .grid { display: grid; grid-template-columns: 1fr 1fr; gap: 20px; margin: 20px 0; }
        .stats { text-align: center; padding: 20px; background: #e9ecef; border-radius: 5px; }
        .btn { background: #007bff; color: white; padding: 10px 20px; border: none; border-radius: 5px; text-decoration: none; display: inline-block; margin: 5px; }
        .btn:hover { background: #0056b3; }
        .btn-success { background: #28a745; }
        .btn-danger { background: #dc3545; }
        table { width: 100%; border-collapse: collapse; margin: 10px 0; }
        th, td { border: 1px solid #ddd; padding: 8px; text-align: left; }
        th { background: #f8f9fa; }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>🔍 Verificação da Instalação</h1>
            <p>Sistema GED - cPanel Edition</p>
            <p><strong>Database:</strong> <?php echo $config['db_name']; ?> | <strong>User:</strong> <?php echo $config['db_user']; ?></p>
        </div>

        <?php
        // Função para testar conexão
        function testConnection($config) {
            try {
                $dsn = "mysql:host={$config['db_host']};dbname={$config['db_name']};charset=utf8mb4";
                $pdo = new PDO($dsn, $config['db_user'], $config['db_pass']);
                $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
                return ['success' => true, 'pdo' => $pdo, 'message' => 'Conexão estabelecida com sucesso!'];
            } catch (PDOException $e) {
                return ['success' => false, 'pdo' => null, 'message' => 'Erro: ' . $e->getMessage()];
            }
        }

        // Teste de conexão
        $connectionTest = testConnection($config);
        ?>

        <!-- Teste de Conexão -->
        <div class="check-item <?php echo $connectionTest['success'] ? 'success' : 'error'; ?>">
            <h3>1. Conexão com Banco de Dados</h3>
            <?php if ($connectionTest['success']): ?>
                <p>✅ <?php echo $connectionTest['message']; ?></p>
                <div class="code">
                    Host: <?php echo $config['db_host']; ?><br>
                    Database: <?php echo $config['db_name']; ?><br>
                    Usuário: <?php echo $config['db_user']; ?>
                </div>
            <?php else: ?>
                <p>❌ <?php echo $connectionTest['message']; ?></p>
                <div class="warning">
                    <strong>Ações necessárias:</strong><br>
                    1. Verifique se o banco '<?php echo $config['db_name']; ?>' foi criado<br>
                    2. Verifique se o usuário '<?php echo $config['db_user']; ?>' existe<br>
                    3. Confirme se a senha está correta<br>
                    4. Verifique as permissões do usuário no banco
                </div>
            <?php endif; ?>
        </div>

        <?php if ($connectionTest['success']): ?>
            <?php
            $pdo = $connectionTest['pdo'];
            
            // Verificar tabelas
            $requiredTables = ['user', 'document', 'category', 'workflow', 'audit_log', 'permission', 'user_permission', 'workflow_step', 'workflow_approval', 'document_version', 'document_keywords'];
            $existingTables = [];
            
            foreach ($requiredTables as $table) {
                try {
                    $stmt = $pdo->prepare("SHOW TABLES LIKE ?");
                    $stmt->execute([$table]);
                    if ($stmt->rowCount() > 0) {
                        $existingTables[] = $table;
                    }
                } catch (Exception $e) {
                    // Tabela não existe
                }
            }
            
            $missingTables = array_diff($requiredTables, $existingTables);
            ?>

            <!-- Verificação de Tabelas -->
            <div class="check-item <?php echo empty($missingTables) ? 'success' : 'warning'; ?>">
                <h3>2. Estrutura do Banco de Dados</h3>
                <?php if (empty($missingTables)): ?>
                    <p>✅ Todas as <?php echo count($requiredTables); ?> tabelas necessárias estão presentes</p>
                    <div class="grid">
                        <div>
                            <strong>Tabelas do Sistema:</strong>
                            <div class="code">
                                <?php echo implode('<br>', $existingTables); ?>
                            </div>
                        </div>
                        <div>
                            <strong>Status:</strong>
                            <div class="stats">
                                <h4><?php echo count($existingTables); ?>/<?php echo count($requiredTables); ?></h4>
                                <p>Tabelas OK</p>
                            </div>
                        </div>
                    </div>
                <?php else: ?>
                    <p>⚠️ Algumas tabelas estão faltando</p>
                    <div class="grid">
                        <div>
                            <strong>Tabelas Encontradas (<?php echo count($existingTables); ?>):</strong>
                            <div class="code">
                                <?php echo implode('<br>', $existingTables); ?>
                            </div>
                        </div>
                        <div>
                            <strong>Tabelas Faltantes (<?php echo count($missingTables); ?>):</strong>
                            <div class="code">
                                <?php echo implode('<br>', $missingTables); ?>
                            </div>
                        </div>
                    </div>
                    <div class="warning">
                        <strong>Ação necessária:</strong> Execute novamente o script SQL de instalação
                    </div>
                <?php endif; ?>
            </div>

            <?php
            // Verificar usuário admin
            try {
                $stmt = $pdo->prepare("SELECT * FROM user WHERE username = 'admin'");
                $stmt->execute();
                $admin = $stmt->fetch();
                
                // Contar registros
                $stats = [];
                foreach (['user', 'category', 'document', 'audit_log', 'permission'] as $table) {
                    try {
                        $stmt = $pdo->prepare("SELECT COUNT(*) as count FROM $table");
                        $stmt->execute();
                        $result = $stmt->fetch();
                        $stats[$table] = $result['count'];
                    } catch (Exception $e) {
                        $stats[$table] = 'N/A';
                    }
                }
            } catch (Exception $e) {
                $admin = false;
                $stats = [];
            }
            ?>

            <!-- Verificação do Usuário Admin -->
            <div class="check-item <?php echo $admin ? 'success' : 'warning'; ?>">
                <h3>3. Usuário Administrador</h3>
                <?php if ($admin): ?>
                    <p>✅ Usuário admin encontrado e configurado</p>
                    <table>
                        <tr><th>Campo</th><th>Valor</th></tr>
                        <tr><td>ID</td><td><?php echo $admin['id']; ?></td></tr>
                        <tr><td>Username</td><td><?php echo $admin['username']; ?></td></tr>
                        <tr><td>Email</td><td><?php echo $admin['email']; ?></td></tr>
                        <tr><td>Nome Completo</td><td><?php echo $admin['full_name']; ?></td></tr>
                        <tr><td>Função</td><td><?php echo $admin['role']; ?></td></tr>
                        <tr><td>Status</td><td><?php echo $admin['is_active'] ? 'Ativo' : 'Inativo'; ?></td></tr>
                        <tr><td>Criado em</td><td><?php echo $admin['created_at']; ?></td></tr>
                    </table>
                <?php else: ?>
                    <p>⚠️ Usuário admin não encontrado</p>
                    <div class="warning">
                        <strong>Ação necessária:</strong> Execute o script SQL para criar o usuário admin
                    </div>
                <?php endif; ?>
            </div>

            <!-- Estatísticas do Sistema -->
            <div class="check-item info">
                <h3>4. Estatísticas do Sistema</h3>
                <div class="grid">
                    <div class="stats">
                        <h4><?php echo $stats['user'] ?? 0; ?></h4>
                        <p>Usuários</p>
                    </div>
                    <div class="stats">
                        <h4><?php echo $stats['category'] ?? 0; ?></h4>
                        <p>Categorias</p>
                    </div>
                    <div class="stats">
                        <h4><?php echo $stats['document'] ?? 0; ?></h4>
                        <p>Documentos</p>
                    </div>
                    <div class="stats">
                        <h4><?php echo $stats['audit_log'] ?? 0; ?></h4>
                        <p>Logs</p>
                    </div>
                    <div class="stats">
                        <h4><?php echo $stats['permission'] ?? 0; ?></h4>
                        <p>Permissões</p>
                    </div>
                </div>
            </div>

        <?php endif; ?>

        <!-- Verificação de Arquivos -->
        <div class="check-item">
            <h3>5. Verificação de Arquivos e Diretórios</h3>
            <?php
            $files = [
                'index.php' => 'Página inicial',
                'login.php' => 'Página de login',
                'dashboard.php' => 'Dashboard',
                'config/database.php' => 'Configuração do banco',
                'config/config.php' => 'Configuração geral'
            ];
            
            $directories = [
                'uploads' => 'Diretório de uploads',
                'logs' => 'Diretório de logs',
                'controllers' => 'Controladores',
                'models' => 'Modelos',
                'includes' => 'Arquivos de inclusão'
            ];
            
            echo "<div class='grid'>";
            echo "<div><strong>Arquivos Principais:</strong><br>";
            foreach ($files as $file => $desc) {
                $exists = file_exists($file);
                echo "<div class='code'>" . ($exists ? "✅" : "❌") . " $file - $desc</div>";
            }
            echo "</div>";
            
            echo "<div><strong>Diretórios:</strong><br>";
            foreach ($directories as $dir => $desc) {
                $exists = is_dir($dir);
                $writable = $exists ? is_writable($dir) : false;
                $status = $exists ? ($writable ? "✅" : "⚠️") : "❌";
                echo "<div class='code'>$status $dir - $desc" . ($exists && !$writable ? " (sem escrita)" : "") . "</div>";
            }
            echo "</div>";
            echo "</div>";
            ?>
        </div>

        <!-- Informações do PHP -->
        <div class="check-item info">
            <h3>6. Informações do Ambiente</h3>
            <div class="grid">
                <div>
                    <strong>PHP:</strong>
                    <div class="code">
                        Versão: <?php echo PHP_VERSION; ?><br>
                        SAPI: <?php echo php_sapi_name(); ?><br>
                        Memória: <?php echo ini_get('memory_limit'); ?><br>
                        Upload Max: <?php echo ini_get('upload_max_filesize'); ?><br>
                        Post Max: <?php echo ini_get('post_max_size'); ?>
                    </div>
                </div>
                <div>
                    <strong>Extensões:</strong>
                    <div class="code">
                        <?php
                        $required_extensions = ['pdo', 'pdo_mysql', 'mbstring', 'json', 'session'];
                        foreach ($required_extensions as $ext) {
                            $loaded = extension_loaded($ext);
                            echo ($loaded ? "✅" : "❌") . " $ext<br>";
                        }
                        ?>
                    </div>
                </div>
            </div>
        </div>

        <!-- Resumo Final -->
        <div class="check-item <?php echo ($connectionTest['success'] && empty($missingTables) && $admin) ? 'success' : 'warning'; ?>">
            <h3>7. Resumo da Instalação</h3>
            <?php if ($connectionTest['success'] && empty($missingTables) && $admin): ?>
                <div class="success">
                    <h4>🎉 Sistema Instalado com Sucesso!</h4>
                    <p><strong>O Sistema GED está pronto para uso!</strong></p>
                    
                    <div style="margin: 20px 0;">
                        <a href="login.php" class="btn btn-success">🚀 Acessar Sistema</a>
                        <a href="dashboard.php" class="btn">📊 Dashboard</a>
                        <a href="install_cpanel.php" class="btn">🔧 Instalação Detalhada</a>
                    </div>
                    
                    <div class="info">
                        <strong>Credenciais de Acesso:</strong><br>
                        <div class="code">
                            Usuário: admin<br>
                            Senha: admin123<br>
                            <strong style="color: red;">⚠️ ALTERE A SENHA IMEDIATAMENTE APÓS O PRIMEIRO LOGIN!</strong>
                        </div>
                    </div>
                </div>
            <?php else: ?>
                <div class="warning">
                    <h4>⚠️ Instalação Incompleta</h4>
                    <p>Alguns problemas foram identificados. Corrija-os antes de usar o sistema:</p>
                    <ul>
                        <?php if (!$connectionTest['success']): ?>
                            <li>❌ Problema de conexão com banco de dados</li>
                        <?php endif; ?>
                        <?php if (!empty($missingTables)): ?>
                            <li>❌ Tabelas faltantes no banco de dados</li>
                        <?php endif; ?>
                        <?php if (!$admin): ?>
                            <li>❌ Usuário administrador não encontrado</li>
                        <?php endif; ?>
                    </ul>
                    
                    <div style="margin: 20px 0;">
                        <a href="install_cpanel.php" class="btn btn-danger">🔧 Executar Instalação</a>
                        <a href="verificar_instalacao.php" class="btn">🔄 Verificar Novamente</a>
                    </div>
                </div>
            <?php endif; ?>
        </div>

        <div class="check-item info">
            <h3>📞 Suporte</h3>
            <p><strong>Em caso de problemas:</strong></p>
            <ol>
                <li>Consulte o manual de instalação</li>
                <li>Verifique os logs de erro do servidor</li>
                <li>Execute novamente o script SQL de instalação</li>
                <li>Verifique as permissões de arquivos e diretórios</li>
            </ol>
            
            <div class="code">
                <strong>Configurações desta instalação:</strong><br>
                Database: <?php echo $config['db_name']; ?><br>
                Username: <?php echo $config['db_user']; ?><br>
                Host: <?php echo $config['db_host']; ?><br>
                Verificação executada em: <?php echo date('d/m/Y H:i:s'); ?>
            </div>
        </div>
    </div>
</body>
</html>

