# Sistema de Gerenciamento Eletrônico de Documentos (GED)

Sistema completo para gerenciamento eletrônico de documentos desenvolvido em PHP com MySQL, oferecendo uma solução robusta para armazenamento, classificação, controle de versões e workflow de aprovação de documentos.

## Características Principais

- **Autenticação e Controle de Acesso**
  - Login seguro com diferentes níveis de usuário (admin, usuários comuns)
  - Sistema de permissões granular
  - Proteção contra ataques de força bruta

- **Dashboard Informativo**
  - Resumo de documentos recentes
  - Estatísticas de documentos por status
  - Visualização de aprovações pendentes

- **Gerenciamento de Documentos**
  - Upload de múltiplos formatos (PDF, DOCX, imagens, etc.)
  - Metadados completos (título, autor, data, tipo, palavras-chave)
  - Classificação automática por categorias
  - Controle de versões com histórico e comparação

- **Pesquisa Avançada**
  - Busca por nome, tipo, data, autor
  - Filtros combinados
  - Pesquisa no conteúdo OCR

- **Workflow de Aprovação**
  - Fluxos de trabalho configuráveis
  - Múltiplos estágios de aprovação
  - Notificações de status

- **Logs e Auditoria**
  - Rastreabilidade completa de ações
  - Histórico detalhado de atividades
  - Relatórios de auditoria

- **Backup Automático**
  - Configuração de backups programados
  - Opções de armazenamento local ou em nuvem
  - Restauração de dados

- **Design Moderno**
  - Interface limpa e intuitiva
  - Layout responsivo para todos os dispositivos
  - Suporte a tema escuro e claro

## Requisitos do Sistema

- PHP 7.4 ou superior
- MySQL 5.7 ou superior
- Servidor web (Apache, Nginx)
- Extensões PHP: PDO, MySQLi, GD, Zip, mbstring

## Instalação

1. **Preparação do Banco de Dados**
   - Crie um banco de dados MySQL
   - Importe o arquivo `database/setup.sql`

2. **Configuração do Sistema**
   - Copie todos os arquivos para o diretório do servidor web
   - Renomeie o arquivo `.env.example` para `.env`
   - Edite o arquivo `.env` com as configurações do seu ambiente

3. **Configuração do Servidor Web**
   - Configure o servidor web para apontar para o diretório de instalação
   - Certifique-se de que o diretório `uploads` tenha permissões de escrita

4. **Primeiro Acesso**
   - Acesse o sistema usando o navegador
   - Faça login com as credenciais padrão:
     - Usuário: admin
     - Senha: __REMOVED_PASSWORD__
   - Altere a senha imediatamente após o primeiro login

## Estrutura de Diretórios

```
ged_php/
├── config/             # Arquivos de configuração
├── controllers/        # Controladores da aplicação
├── models/             # Modelos de dados
├── includes/           # Arquivos de inclusão (header, footer, etc.)
├── assets/             # Arquivos estáticos (CSS, JS, imagens)
├── uploads/            # Diretório para upload de documentos
├── database/           # Scripts SQL e migrações
├── vendor/             # Bibliotecas de terceiros
└── index.php           # Ponto de entrada da aplicação
```

## Segurança

- Todas as senhas são armazenadas com hash seguro
- Proteção contra SQL Injection através de prepared statements
- Proteção contra CSRF em todos os formulários
- Validação de entrada em todos os campos
- Controle de sessão seguro

## Customização

O sistema pode ser facilmente customizado através das configurações disponíveis no painel administrativo:

- Aparência (cores, logo, tema)
- Configurações de e-mail
- Configurações de backup
- Tipos de documentos permitidos
- Fluxos de trabalho personalizados

## Suporte

Para suporte técnico ou dúvidas sobre o sistema, entre em contato através do e-mail suporte@sysged.com.br

---

© 2025 Sistema GED - Todos os direitos reservados
