<?php
/**
 * Script para exportar logs de auditoria para CSV
 * Sistema de Gerenciamento Eletrônico de Documentos (GED)
 */

// Iniciar sessão e verificar autenticação
session_start();
if (!isset($_SESSION["user_id"])) {
    header("Location: login.php");
    exit;
}

// Verificar se o usuário tem permissão de administrador
if ($_SESSION["user_type"] != "admin") {
    $_SESSION["flash_message"] = "Acesso negado. Você não tem permissão para acessar esta funcionalidade.";
    $_SESSION["flash_type"] = "danger";
    header("Location: index.php");
    exit;
}

// Incluir arquivos necessários
require_once "config/database.php";
require_once "models/audit_log.php";
require_once "controllers/audit_log_controller.php";

// Conectar ao banco de dados
$database = new Database();
$db = $database->getConnection();

// Instanciar controlador
$audit_log_controller = new AuditLogController();

// Definir filtros (reutilizar os filtros da página de logs)
$user_id = $_GET["user_id"] ?? null;
$action_type = $_GET["action_type"] ?? null;
$entity_type = $_GET["entity_type"] ?? null;
$date_from = $_GET["date_from"] ?? null;
$date_to = $_GET["date_to"] ?? null;

// Obter todos os logs de auditoria com os filtros aplicados (sem paginação)
$result = $audit_log_controller->getLogs([
    "user_id" => $user_id,
    "action_type" => $action_type,
    "entity_type" => $entity_type,
    "date_from" => $date_from,
    "date_to" => $date_to,
    "limit" => -1 // Sem limite para exportação
]);

$logs = $result["logs"];

// Nome do arquivo CSV
$filename = getenv('APP_FILENAME') . date("Ymd_His") . ".csv";

// Definir cabeçalhos para download do CSV
header("Content-Type: text/csv");
header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
header("Pragma: no-cache");
header("Expires: 0");

// Abrir o output para escrita
$output = fopen("php://output", "w");

// Escrever o cabeçalho do CSV
fputcsv($output, [
    "ID", 
    "Data/Hora", 
    "Usuario", 
    "Acao", 
    "Tipo Entidade", 
    "ID Entidade", 
    "Detalhes", 
    "IP", 
    "User Agent"
]);

// Escrever os dados dos logs
foreach ($logs as $log) {
    fputcsv($output, [
        $log["id"],
        date("d/m/Y H:i:s", strtotime($log["created_at"])),
        $log["username"],
        $log["action_type"],
        $log["entity_type"],
        $log["entity_id"],
        $log["details"],
        $log["ip_address"],
        $log["user_agent"]
    ]);
}

// Fechar o output
fclose($output);
exit;

?>

