<?php
/**
 * Controlador de Versões de Documentos
 * Sistema de Gerenciamento Eletrônico de Documentos (GED)
 */

require_once __DIR__ . "/../config/database.php";
require_once __DIR__ . "/../models/document_version.php";
require_once __DIR__ . "/../models/audit_log.php";

class DocumentVersionController {
    private $db;
    private $document_version;

    public function __construct() {
        $database = new Database();
        $this->db = $database->getConnection();
        $this->document_version = new DocumentVersion($this->db);
    }

    public function getDocumentVersions($document_id) {
        $this->document_version->document_id = $document_id;
        $stmt = $this->document_version->readByDocumentId();
        $versions = [];
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
            $versions[] = $row;
        }
        return ["success" => true, "versions" => $versions];
    }

    public function getDocumentVersion($document_id, $version_number) {
        $version = $this->document_version->getVersionByDocumentAndNumber($document_id, $version_number);
        if ($version) {
            return ["success" => true, "version" => $version];
        } else {
            return ["success" => false, "message" => "Versão do documento não encontrada."];
        }
    }

    // Este método é chamado pelo DocumentController, mas pode ser exposto para outros fins
    public function createDocumentVersion($data) {
        if (empty($data["document_id"]) || empty($data["version_number"]) || empty($data["file_path"]) || empty($data["file_name"]) || empty($data["file_size"]) || empty($data["file_type"]) || empty($data["created_by"])) {
            return ["success" => false, "message" => "Dados incompletos para criar a versão do documento."];
        }

        $this->document_version->document_id = $data["document_id"];
        $this->document_version->version_number = $data["version_number"];
        $this->document_version->file_path = $data["file_path"];
        $this->document_version->file_name = $data["file_name"];
        $this->document_version->file_size = $data["file_size"];
        $this->document_version->file_type = $data["file_type"];
        $this->document_version->created_by = $data["created_by"];
        $this->document_version->changes = $data["changes"] ?? "";

        if ($this->document_version->create()) {
            logAudit($_SESSION["user_id"], "create_version", "document_version", $this->document_version->id, "Versão " . $this->document_version->version_number . " criada para o documento " . $this->document_version->document_id);
            return ["success" => true, "message" => "Versão do documento criada com sucesso.", "version_id" => $this->document_version->id];
        } else {
            return ["success" => false, "message" => "Erro ao criar versão do documento."];
        }
    }

    public function deleteDocumentVersionsByDocumentId($document_id) {
        $this->document_version->document_id = $document_id;
        if ($this->document_version->deleteByDocumentId()) {
            logAudit($_SESSION["user_id"], "delete_versions", "document", $document_id, "Todas as versões do documento " . $document_id . " foram excluídas.");
            return ["success" => true, "message" => "Versões do documento excluídas com sucesso."];
        } else {
            return ["success" => false, "message" => "Erro ao excluir versões do documento."];
        }
    }
}
?>

