<?php
/**
 * Controlador de Permissões
 * Sistema de Gerenciamento Eletrônico de Documentos (GED)
 */

require_once __DIR__ . "/../config/database.php";
require_once __DIR__ . "/../models/permission.php";
require_once __DIR__ . "/../models/audit_log.php";

class PermissionController {
    private $db;
    private $permission;

    public function __construct() {
        $database = new Database();
        $this->db = $database->getConnection();
        $this->permission = new Permission($this->db);
    }

    public function createPermission($data, $user_id) {
        if (empty($data["name"]) || empty($data["description"])) {
            return ["success" => false, "message" => "Nome e descrição da permissão são obrigatórios."];
        }

        $this->permission->name = $data["name"];
        $this->permission->description = $data["description"];

        if ($this->permission->create()) {
            logAudit($user_id, "create", "permission", $this->permission->id, "Permissão criada: " . $this->permission->name);
            return ["success" => true, "message" => "Permissão criada com sucesso.", "permission_id" => $this->permission->id];
        } else {
            return ["success" => false, "message" => "Erro ao criar permissão."];
        }
    }

    public function getPermission($id) {
        $this->permission->id = $id;
        if ($this->permission->readOne()) { // Assumindo que readOne existe no modelo Permission
            return ["success" => true, "permission" => [
                "id" => $this->permission->id,
                "name" => $this->permission->name,
                "description" => $this->permission->description
            ]];
        } else {
            return ["success" => false, "message" => "Permissão não encontrada."];
        }
    }

    public function getAllPermissions() {
        $stmt = $this->permission->readAll();
        $permissions = [];
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
            $permissions[] = $row;
        }
        return $permissions;
    }

    public function updatePermission($data) {
        if (empty($data["id"]) || empty($data["name"]) || empty($data["description"])) {
            return ["success" => false, "message" => "ID, nome e descrição da permissão são obrigatórios."];
        }

        $this->permission->id = $data["id"];
        $this->permission->name = $data["name"];
        $this->permission->description = $data["description"];

        if ($this->permission->update()) {
            logAudit($_SESSION["user_id"], "update", "permission", $data["id"], "Permissão atualizada: " . $data["name"]);
            return ["success" => true, "message" => "Permissão atualizada com sucesso."];
        } else {
            return ["success" => false, "message" => "Erro ao atualizar permissão."];
        }
    }

    public function deletePermission($id) {
        $this->permission->id = $id;
        if ($this->permission->delete()) {
            logAudit($_SESSION["user_id"], "delete", "permission", $id, "Permissão excluída: " . $id);
            return ["success" => true, "message" => "Permissão excluída com sucesso."];
        } else {
            return ["success" => false, "message" => "Erro ao excluir permissão."];
        }
    }
}
?>

