<!-- Sidebar -->
<nav id="sidebar" class="col-md-3 col-lg-2 d-md-block bg-light sidebar collapse">
    <div class="position-sticky pt-3">
        <ul class="nav flex-column">
            <li class="nav-item">
                <a class="nav-link <?php echo (basename($_SERVER['PHP_SELF']) == 'index.php') ? 'active' : ''; ?>" aria-current="page" href="index.php">
                    <i class="fas fa-home me-2"></i>
                    Dashboard
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link <?php echo (basename($_SERVER['PHP_SELF']) == 'documents.php' || basename($_SERVER['PHP_SELF']) == 'document_add.php' || basename($_SERVER['PHP_SELF']) == 'document_view.php' || basename($_SERVER['PHP_SELF']) == 'document_edit.php') ? 'active' : ''; ?>" href="documents.php">
                    <i class="fas fa-file-alt me-2"></i>
                    Documentos
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link <?php echo (basename($_SERVER['PHP_SELF']) == 'document_approval.php') ? 'active' : ''; ?>" href="document_approval.php">
                    <i class="fas fa-check-double me-2"></i>
                    Aprovações
                    <?php 
                        require_once 'config/database.php';
                        require_once 'models/document.php';
                        require_once 'controllers/document_controller.php';
                        $database = new Database();
                        $db = $database->getConnection();
                        $document_controller = new DocumentController();
                        $pending_count = $document_controller->getPendingApprovalsCount($_SESSION['user_id'], $_SESSION['user_type']);
                        if ($pending_count > 0) {
                            echo '<span class="badge bg-danger rounded-pill ms-2">' . $pending_count . '</span>';
                        }
                    ?>
                </a>
            </li>
            <?php if ($_SESSION['user_type'] == 'admin'): ?>
            <li class="nav-item">
                <a class="nav-link <?php echo (basename($_SERVER['PHP_SELF']) == 'categories.php') ? 'active' : ''; ?>" href="categories.php">
                    <i class="fas fa-tags me-2"></i>
                    Categorias
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link <?php echo (basename($_SERVER['PHP_SELF']) == 'workflows.php') ? 'active' : ''; ?>" href="workflows.php">
                    <i class="fas fa-project-diagram me-2"></i>
                    Workflows
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link <?php echo (basename($_SERVER['PHP_SELF']) == 'users.php') ? 'active' : ''; ?>" href="users.php">
                    <i class="fas fa-users me-2"></i>
                    Usuários
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link <?php echo (basename($_SERVER['PHP_SELF']) == 'audit_logs.php') ? 'active' : ''; ?>" href="audit_logs.php">
                    <i class="fas fa-history me-2"></i>
                    Logs de Auditoria
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link <?php echo (basename($_SERVER['PHP_SELF']) == 'settings.php') ? 'active' : ''; ?>" href="settings.php">
                    <i class="fas fa-cogs me-2"></i>
                    Configurações
                </a>
            </li>
            <?php endif; ?>
        </ul>

        <h6 class="sidebar-heading d-flex justify-content-between align-items-center px-3 mt-4 mb-1 text-muted">
            <span>Minha Conta</span>
        </h6>
        <ul class="nav flex-column mb-2">
            <li class="nav-item">
                <a class="nav-link" href="#">
                    <i class="fas fa-user-circle me-2"></i>
                    Perfil
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link" href="logout.php">
                    <i class="fas fa-sign-out-alt me-2"></i>
                    Sair
                </a>
            </li>
        </ul>
    </div>
</nav>

