<?php
class DocumentKeywords {
    private $conn;
    private $table_name = getenv('APP_TABLE_NAME');

    public $document_id;
    public $keyword;

    public function __construct($db) {
        $this->conn = $db;
    }

    public function create() {
        $query = getenv('APP_QUERY') . $this->table_name . "
                SET
                    document_id=:document_id,
                    keyword=:keyword";

        $stmt = $this->conn->prepare($query);

        // sanitize
        $this->document_id = htmlspecialchars(strip_tags($this->document_id));
        $this->keyword = htmlspecialchars(strip_tags($this->keyword));

        // bind values
        $stmt->bindParam(":document_id", $this->document_id);
        $stmt->bindParam(":keyword", $this->keyword);

        if ($stmt->execute()) {
            return true;
        }

        return false;
    }

    public function readByDocumentId() {
        $query = getenv('APP_QUERY') . $this->table_name . " WHERE document_id = ?";

        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(1, $this->document_id);
        $stmt->execute();

        return $stmt;
    }

    public function deleteByDocumentId() {
        $query = getenv('APP_QUERY') . $this->table_name . " WHERE document_id = ?";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(1, $this->document_id);

        if ($stmt->execute()) {
            return true;
        }
        return false;
    }
}
?>

