<?php
class DocumentVersion {
    private $conn;
    private $table_name = getenv('APP_TABLE_NAME');

    public $id;
    public $document_id;
    public $version_number;
    public $file_path;
    public $file_name;
    public $file_size;
    public $file_type;
    public $created_by;
    public $changes;
    public $created_at;

    public function __construct($db) {
        $this->conn = $db;
    }

    public function create() {
        $query = getenv('APP_QUERY') . $this->table_name . "
                SET
                    document_id=:document_id,
                    version_number=:version_number,
                    file_path=:file_path,
                    file_name=:file_name,
                    file_size=:file_size,
                    file_type=:file_type,
                    created_by=:created_by,
                    changes=:changes";

        $stmt = $this->conn->prepare($query);

        // sanitize
        $this->document_id = htmlspecialchars(strip_tags($this->document_id));
        $this->version_number = htmlspecialchars(strip_tags($this->version_number));
        $this->file_path = htmlspecialchars(strip_tags($this->file_path));
        $this->file_name = htmlspecialchars(strip_tags($this->file_name));
        $this->file_size = htmlspecialchars(strip_tags($this->file_size));
        $this->file_type = htmlspecialchars(strip_tags($this->file_type));
        $this->created_by = htmlspecialchars(strip_tags($this->created_by));
        $this->changes = htmlspecialchars(strip_tags($this->changes));

        // bind values
        $stmt->bindParam(":document_id", $this->document_id);
        $stmt->bindParam(":version_number", $this->version_number);
        $stmt->bindParam(":file_path", $this->file_path);
        $stmt->bindParam(":file_name", $this->file_name);
        $stmt->bindParam(":file_size", $this->file_size);
        $stmt->bindParam(":file_type", $this->file_type);
        $stmt->bindParam(":created_by", $this->created_by);
        $stmt->bindParam(":changes", $this->changes);

        if ($stmt->execute()) {
            return true;
        }

        return false;
    }

    public function readByDocumentId() {
        $query = "SELECT
                    dv.id, dv.document_id, dv.version_number, dv.file_path, dv.file_name, dv.file_size, dv.file_type, dv.changes, dv.created_at,
                    u.name as created_by_name
                FROM
                    " . $this->table_name . " dv
                    LEFT JOIN
                        user u ON dv.created_by = u.id
                WHERE
                    dv.document_id = ?
                ORDER BY
                    dv.version_number DESC";

        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(1, $this->document_id);
        $stmt->execute();

        return $stmt;
    }

    public function getVersionByDocumentAndNumber($document_id, $version_number) {
        $query = getenv('APP_QUERY') . $this->table_name . "
                WHERE
                    document_id = ? AND version_number = ?
                LIMIT
                    0,1";

        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(1, $document_id);
        $stmt->bindParam(2, $version_number);
        $stmt->execute();

        $row = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($row) {
            return $row;
        }
        return false;
    }

    public function getLatestVersionNumber($document_id) {
        $query = getenv('APP_QUERY') . $this->table_name . " WHERE document_id = ?";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(1, $document_id);
        $stmt->execute();
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
        return $row["latest_version"] ? $row["latest_version"] : 0;
    }

    public function deleteByDocumentId() {
        $query = getenv('APP_QUERY') . $this->table_name . " WHERE document_id = ?";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(1, $this->document_id);

        if ($stmt->execute()) {
            return true;
        }
        return false;
    }
}
?>

